package com.tenqube.visual_third;

import android.support.annotation.NonNull;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.OnResultListener;

public interface VisualService {

    /**
     * 처음 가입 무조건 실행 해야함
     * @param uid 사용자 아이디
     * @param onResultListener 미가입시 가입결과를 위한 콜백 함수
     */
    void signUp(@NonNull String uid, @NonNull OnResultListener onResultListener) throws ParameterException;

    /**
     * 비주얼 가계부 화면 호출
     * 가입되지 않은 사용자 가입처리를 위해 파라미터 추가
     *
     * @param uid 사용자 아이디
     * @param onResultListener 미가입시 가입결과를 위한 콜백 함수
     */
    void startVisual(@NonNull String uid, @NonNull OnResultListener onResultListener) throws ParameterException, SecurityException;

    /**
     * 팝업 보여질지 여부를 확인 합니다.
     * @return 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    boolean isActiveTranPopup();

    /**
     * 팝업 호출 여부
     * @param isActive 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    void setTranPopup(boolean isActive);
    /**
     * 로그 확인을 위한 디버그 적용 함수
     * @param isDebug 디버그 여부
     */
    void setDebugMode(boolean isDebug);

    /**
     * SDK초기화 함수 개발 전용
     */
    void initSDK();

    /**
     * SDK 사용 여부 판단 플레그
     * @param enabled true : 동작 / false : 동작 안함.
     */
    void setEnabled(boolean enabled);

    /**
     * 알림 기본 설정
     * @param channel 채널정보
     * @param color 아이콘 색
     * @throws ParameterException
     */
    void settingNotification(String channel, int color) throws ParameterException;

    /**
     * 월간 알림 리포트
     * @param isActive 활성화 여부
     */
    void setMonthlyNoti(boolean isActive);

    /**
     * 월간 알림 리포트 확인
     * @return isActive 활성화 여부
     */
    boolean isActiveMonthlyNoti();

    /**
     * 주간 알림 리포트 설정
     * @param isActive 활성화 여부
     */
    void setWeeklyNoti(boolean isActive);

    /**
     * 주간 알림 설정 확인
     * @return 활성화 여부
     */
    boolean isActiveWeeklyNoti();

    /**
     * 일간 알림 설정
     * @param isActive 활성화 여부
     */
    void setDailyNoti(boolean isActive);

    /**
     * 일간 알림 설정 확인
     * @return 활성화 여부
     */
    boolean isActiveDailyNoti();

    /**
     * 알림 테스트 함수
     * @param type IN(Constants.NotificationType.MONTHLY, Constants.NotificationType.DAILY, Constants.NotificationType.WEEKLY_MON, Constants.NotificationType.WEEKLY_FRI)
     * @param second
     */
    void setReportTest(String type, int second);

}
