/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.thirdparty.mart;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSimple;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSimpleLoginTestResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSimpleScrapResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSvrType;
import com.ksp.mobilesdkjava.MarketSystem.BOE.Receipt;
import com.ksp.mobilesdkjava.MarketSystem.BOE.ReceiptProduct;
import com.ksp.mobilesdkjava.MarketSystem.Base.e_MarketKeyCode;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.thirdparty.mart.MartData;
import com.tenqube.visual_scraper.thirdparty.mart.MartScrapper;
import com.tenqube.visual_scraper.utils.AppExecutors;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import timber.log.Timber;

public class MartScrapperImpl
implements MartScrapper {
    private Context context;
    private static MartScrapper mInstance = null;
    private AppExecutors appExecutors = new AppExecutors();
    private boolean isInit = false;
    SDKAssistSimple sdkInstance = null;
    boolean isRetry = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MartScrapper getInstance(Context ctx) {
        Class<MartScrapperImpl> clazz = MartScrapperImpl.class;
        synchronized (MartScrapperImpl.class) {
            if (mInstance == null) {
                mInstance = new MartScrapperImpl(ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private MartScrapperImpl(Context context) {
        this.context = context;
    }

    @Override
    public void init(ScrapService.Callback<String> callback) {
        if (this.isInit) {
            callback.onDataLoaded("");
        } else {
            this.appExecutors.diskIO().execute(() -> {
                String msg = "";
                File root_file = this.context.getFilesDir();
                String root_path = root_file.getAbsolutePath();
                String appName = "visual";
                try {
                    this.sdkInstance = new SDKAssistSimple(root_path, appName, SDKAssistSvrType.e_SvrType.TenqubeProd);
                    this.isInit = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    msg = e.toString();
                }
                finally {
                    String finalMsg = msg;
                    this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
                }
            });
        }
    }

    @Override
    public void requestMobileAuthCode(String phoneNumber, String birth, String name, ScrapService.Callback<Boolean> onResult) throws Exception {
        this.appExecutors.diskIO().execute(() -> {
            try {
                this.sdkInstance.RequestHomePlusHPAuthCode(phoneNumber, birth, name);
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(true));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(false));
            }
        });
    }

    @Override
    public void startHomeplusLogin(String authCode, String phoneNumber, ScrapService.Callback<Boolean> onResult) throws Exception {
        this.appExecutors.diskIO().execute(() -> {
            try {
                this.sdkInstance.ConfirmHomePlusHPAuthCode(authCode);
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(true));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.appExecutors.mainThread().execute(() -> onResult.onDataLoaded(false));
            }
        });
    }

    @Override
    public void addUser(int mallId, String id, String password, ScrapService.Callback<String> callback) {
        this.appExecutors.diskIO().execute(() -> {
            String msg = "";
            try {
                e_MarketKeyCode keyCode = this.getMarketKeyCode(mallId);
                SDKAssistSimpleLoginTestResult ret = this.sdkInstance.LoginTest(keyCode, id, password);
                if (!ret.Success) {
                    throw ret.Ex;
                }
                String finalMsg = msg;
                this.isRetry = false;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
            }
            catch (Exception e) {
                e.printStackTrace();
                msg = e.toString();
                if (!this.isRetry && mallId == Constants.MALL.Emart.getMallId()) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.postDelayed(() -> {
                        this.isRetry = true;
                        this.addUser(mallId, id, password, callback);
                    }, 1500L);
                    return;
                }
                String finalMsg = msg;
                this.isRetry = false;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
            }
        });
    }

    @Override
    public void start(int mallId, String id, String pwd, ScrapService.Callback<List<MartData>> callback) {
        this.appExecutors.networkIO().execute(() -> {
            String msg = "";
            List<Object> results = new ArrayList();
            try {
                SDKAssistSimpleScrapResult ret;
                Calendar _toDate = Calendar.getInstance();
                e_MarketKeyCode keyCode = this.getMarketKeyCode(mallId);
                if (keyCode == e_MarketKeyCode.HomePlus) {
                    Calendar curDate = Calendar.getInstance();
                    Calendar fromDate = Calendar.getInstance();
                    fromDate.add(2, -6);
                    ret = this.sdkInstance.ScrapReceiptHomePlusHP(id, pwd, curDate, fromDate);
                } else {
                    ret = this.sdkInstance.ScrapReceipt(keyCode, id, pwd, _toDate, null);
                }
                if (!ret.Success) {
                    throw ret.Ex;
                }
                results = this.getMartItems(mallId, (ArrayList<Receipt>)ret.ScrappedReceiptList, (ArrayList<ReceiptProduct>)ret.ScrappedReceiptProductList);
            }
            catch (UnsupportedOperationException e) {
                msg = "\uc544\uc774\ub514 \ub610\ub294 \ud328\uc2a4\uc6cc\ub4dc\ub97c \ub2e4\uc2dc \ud655\uc778\ud558\uc138\uc694";
            }
            catch (Exception e) {
                msg = e.toString();
            }
            finally {
                String finalMsg = msg;
                ArrayList finalResults = results;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalResults));
            }
        });
    }

    public List<MartData> getMartItems(int mallId, ArrayList<Receipt> receiptList, ArrayList<ReceiptProduct> productArrayList) {
        ArrayList<MartData> results = new ArrayList<MartData>();
        try {
            if (receiptList != null) {
                Timber.i((String)("ScrapManager" + receiptList.size()), (Object[])new Object[0]);
                for (Receipt rr : receiptList) {
                    Timber.i((String)("ScrapManager mallId " + mallId), (Object[])new Object[0]);
                    Timber.i((String)("ScrapManager getMallId(rr.MartEnumKeyCode) " + this.getMallId(rr.MartEnumKeyCode)), (Object[])new Object[0]);
                    if (mallId != this.getMallId(rr.MartEnumKeyCode)) continue;
                    Timber.i((String)("ScrapManager productArrayList " + productArrayList.size()), (Object[])new Object[0]);
                    for (ReceiptProduct rp : productArrayList) {
                        Timber.i((String)("ScrapManager BuyDate " + rp.BuyDate), (Object[])new Object[0]);
                        Timber.i((String)("ScrapManager InsertDate " + rp.InsertDate), (Object[])new Object[0]);
                        MartData martData = new MartData();
                        martData.barcode = rp.Barcode;
                        martData.buyCount = rp.BuyCount;
                        martData.buyDate = rp.BuyDate;
                        martData.insertDate = rp.InsertDate;
                        martData.name = rp.ProductName;
                        martData.price = rp.UnitPrice.doubleValue();
                        martData.receiptKey = rp.ReceiptKey;
                        martData.receiptProductKey = rp.ReceiptProductKey;
                        martData.orderAmount = rp.OrderAmount.doubleValue();
                        martData.raw = rr.Raw;
                        martData.posNo = rr.PosNo;
                        martData.branchName = rr.MartStoreName;
                        martData.branchAddress = rr.MartAddress;
                        results.add(martData);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    @Override
    public void logout(int mId, String userId) {
        this.appExecutors.diskIO().execute(() -> {
            String msg = "";
        });
    }

    private int getMallId(e_MarketKeyCode martKey) {
        if (martKey == e_MarketKeyCode.LotteMCoupon) {
            return Constants.MALL.LotteMart.getMallId();
        }
        if (martKey == e_MarketKeyCode.EMartApp) {
            return Constants.MALL.Emart.getMallId();
        }
        if (martKey == e_MarketKeyCode.HomePlus) {
            return Constants.MALL.Homeplus.getMallId();
        }
        return -1;
    }

    private e_MarketKeyCode getMarketKeyCode(int mallId) {
        if (mallId == Constants.MALL.Emart.getMallId()) {
            return e_MarketKeyCode.EMartApp;
        }
        if (mallId == Constants.MALL.Homeplus.getMallId()) {
            return e_MarketKeyCode.HomePlus;
        }
        return e_MarketKeyCode.LotteMCoupon;
    }
}

