package com.tenqube.visual_scraper.thirdparty.commerce

import android.content.Context
import android.util.Log
import com.tenqube.commerce.domain.entity.*
import com.tenqube.commerce.domain.scraping.online.library.domain.market.util.Utils
import com.tenqube.commerce.domain.usecase.offline.OfflineDto
import com.tenqube.commerce.domain.usecase.online.OnlineDto
import com.tenqube.commerce.domain.utils.toMD5
import com.tenqube.commerce.domain.vo.*
import com.tenqube.commerce.presentation.ScrapBuilder
import com.tenqube.commerce.presentation.ScrapService
import com.tenqube.commerce.presentation.model.Response
import com.tenqube.commerce.utils.Callback
import com.tenqube.visual_scraper.BuildConfig
import com.tenqube.visual_scraper.db.entity.OrderEntity
import com.tenqube.visual_scraper.thirdparty.mart.MartData

class CommerceManager(val context: Context) {

    val scrapService: ScrapService

    init {
        var apiKey = ""
        var layer = ""

        if(BuildConfig.DEBUG) {
            apiKey = "WsTS02mRIg1oSmQbQmC0FaIB9gr0XP8EakGVI8Fy"
            layer = "dev"
        } else {
            apiKey = "Nrcoz4wo1Z8mvEuyZzcFt3QUu3cCKpjC4TtijITZ"
            layer = "prod"
        }

        scrapService = ScrapBuilder()
                .with(context)
                .apiKey(apiKey)
                .layer(layer)
                .hour(0)
                .logger(true)
                .build()
    }

    fun signUp(clientId: String, birth: Int, gender: Int) {
        Log.i("commerce", "signUp" + clientId)

        Log.i("commerce", "signUp" + birth)
        Log.i("commerce", "signUp" + gender)

        scrapService.signUp(clientId, birth, when (gender) {
            1 -> {
                Gender.Male
            }
            0 -> {
                Gender.Female
            }
            else -> {
                Gender.None
            }
        }, object : Callback<Response<Unit>> {
            override fun onDataLoaded(value: Response<Unit>) {
                Log.i("commerce", "signUp" + value)

            }

        })
    }

    fun saveOfflineOrders(mId: Int, items: List<MartData>) {

        try {
            val commerceId = CommerceId.fromOnlineId(mId) ?: return

            val offlineItems = items.mapNotNull {

                try {
                    OfflineDto(
                            id = it.receiptKey.toMD5(),
                            orderNum = it.receiptKey,
                            commerceId = commerceId,
                            totalPrice = Price(it.orderAmount, "KRW"),
                            branch = Branch(it.branchName ?: "", it.branchAddress ?: ""),
                            items = listOf(OrderItem(
                                    id = it.receiptProductKey.toMD5(), // orderNum + index 로 할당 or 상품주문 버호 존재하면 할당.
                                    product = Product.Offline(
                                            id = (if(it.barcode.isNullOrEmpty()) {it.name + ";"+ commerceId.id} else { it.barcode + ";"+ commerceId.id }).toMD5(), // 타이틀, 링크로 아이디로 id
                                            name = it.name,
                                            price = Price(it.price, "KRW"),
                                            barcode = it.barcode ?: ""),
                                    quantity = it.buyCount,
                                    price = Price(it.price, "KRW"),
                                    state = "구매완료")),
                            buyAt = Utils.convertDateTimeStrToCalendar(it.buyDate).timeInMillis,
                            createdAt = System.currentTimeMillis(),
                            raw = it.raw,
                            posNo = it.posNo,
                            isSynced = false
                    )
                } catch (e: Exception) {
                    Log.i("commerce", "saveOfflineOrders" + e)

                    null
                }

            }
            scrapService.saveOfflineOrders(offlineItems)
        } catch (e: Exception) {

        }

    }

    fun saveOnlineOrders(mId: Int, items: List<OrderEntity>) {

        try {

            val commerceId = CommerceId.fromOnlineId(mId) ?: return

            val onlineItems = items.mapNotNull {

                try {


                    val orderId = it.orderNum.toMD5()
                    val productId = (if(it.detailProductLink.isNullOrEmpty()) { it.title + ";" + commerceId.id}
                    else { it.detailProductLink })
                            .toMD5()
                    val orderItemId = (orderId + productId).toMD5()

                    OnlineDto(
                            id = orderId,
                            orderNum = it.orderNum ?: "",
                            commerceId = commerceId,
                            totalPrice = Price(it.price, it.currency  ?: ""),
                            items = listOf(OrderItem(
                                    id = orderItemId, // orderNum + index 로 할당 or 상품주문 버호 존재하면 할당.
                                    product = Product.Online(
                                            id = productId, // 타이틀, 링크로 아이디로 id
                                            name = it.title ?: "",
                                            price = Price(it.price, it.currency  ?: ""),
                                            options = listOf(it.orderOption  ?: ""),
                                            image = Image(it.imgUrl ?: "", it.imgUrl  ?: ""),
                                            link = it.detailProductLink ?: "",
                                            productNum = null),
                                    quantity = it.quantity,
                                    price = Price(it.price, it.currency  ?: ""),
                                    state = it.orderState  ?: "")),
                            buyAt = it.orderDate.time,
                            link = it.detailOrderLink  ?: "",
                            createdAt = System.currentTimeMillis(),
                            isSynced = false
                    )
                } catch (e: java.lang.Exception) {
                    Log.i("commerce", "saveOnlineOrders" + e)

                    null
                }

            }

            scrapService.saveOnlineOrders(onlineItems)
        } catch (e: Exception) {

        }

    }

}