package com.tenqube.visual_scraper.market.util

import android.content.Context
import java.io.IOException
import java.text.SimpleDateFormat
import java.util.*

object Utils {

    fun convertDateTimeStrToCalendar(str: String): Calendar {
        return Calendar.getInstance().apply {  time = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA).parse(str) }
    }

    fun getJsonDataFromAsset(context: Context, fileName: String): String? {
        val jsonString: String

        try {
            jsonString = context.assets.open(fileName).bufferedReader().use { it.readText() }
        } catch (ioException: IOException) {
            ioException.printStackTrace()
            return null
        }
        return jsonString
    }

}