package com.tenqube.visual_scraper.mall;


import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;

public class Hmall extends Mall {

    public Hmall(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    public String getBaseUrl() {
        return "https://www.hyundaihmall.com/";
    }

    @Override
    protected String orderOptionFilter(@NonNull String orderOption) {
        try {
            if (!TextUtils.isEmpty(orderOption)) {
                return orderOption.split("ㅣ")[0]
                        .replace("[", "")
                        .replace("]", "").trim();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return orderOption;
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            if (!TextUtils.isEmpty(quantity)) {

                String[] quantityStrArray = quantity.split("ㅣ");

                if(quantityStrArray.length > 1) {
                    return Integer.parseInt(quantityStrArray[1]
                            .replace("]", "")
                            .replace("개", "")
                            .trim());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public String getLogoutUrl() {
        return "javascript:bizSpringTag('http://www.hyundaihmall.com/front/cob/logout.do','^헤더^마이페이지 레이어^로그아웃');";
    }
}
