package com.tenqube.visual_scraper.market

import android.content.Context
import com.tenqube.visual_scraper.MallViewHandler
import com.tenqube.visual_scraper.webviewhtmlloader.WebViewLoader

object MarketFactory {

    fun createScrapper(key: MarketKey, webViewHtmlLoader: WebViewLoader, context: Context, mallViewHandler: MallViewHandler?): Market? {
        return when(key) {
            MarketKey.COUPANG -> Coupang(webViewHtmlLoader, key, context, mallViewHandler)
            MarketKey.MarketKurly -> MarketKurly(webViewHtmlLoader, key, context, mallViewHandler)
            MarketKey.Gmarket -> Gmarket(webViewHtmlLoader, key, context, mallViewHandler)
            else -> SSG(webViewHtmlLoader, key, context, mallViewHandler)
        }
    }
}