package com.tenqube.visual_scraper.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;

import java.util.List;

@Dao
public interface OrderDetailWebRuleDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderDetailWebRuleJson orderDetailWebRule);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insertList(List<OrderDetailWebRuleJson> orderDetailWebRules);

    @Query("SELECT * FROM order_detail_web_rule " +
            "WHERE mall_id = :mId")
    OrderDetailWebRuleJson getInfo(int mId);

}
