/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.thirdparty.commerce;

import android.content.Context;
import com.tenqube.commerce.domain.entity.OrderItem;
import com.tenqube.commerce.domain.entity.Product;
import com.tenqube.commerce.domain.scraping.online.library.domain.market.util.Utils;
import com.tenqube.commerce.domain.usecase.offline.OfflineDto;
import com.tenqube.commerce.domain.usecase.online.OnlineDto;
import com.tenqube.commerce.domain.utils.StringExtKt;
import com.tenqube.commerce.domain.vo.Branch;
import com.tenqube.commerce.domain.vo.CommerceId;
import com.tenqube.commerce.domain.vo.Gender;
import com.tenqube.commerce.domain.vo.Image;
import com.tenqube.commerce.domain.vo.Price;
import com.tenqube.commerce.presentation.ScrapBuilder;
import com.tenqube.commerce.presentation.ScrapService;
import com.tenqube.commerce.presentation.model.Response;
import com.tenqube.commerce.utils.Callback;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.thirdparty.mart.MartData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\u001e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/tenqube/visual_scraper/thirdparty/commerce/CommerceManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "scrapService", "Lcom/tenqube/commerce/presentation/ScrapService;", "getScrapService", "()Lcom/tenqube/commerce/presentation/ScrapService;", "saveOfflineOrders", "", "mId", "", "items", "", "Lcom/tenqube/visual_scraper/thirdparty/mart/MartData;", "saveOnlineOrders", "Lcom/tenqube/visual_scraper/db/entity/OrderEntity;", "signUp", "clientId", "", "birth", "gender", "app_release"})
public final class CommerceManager {
    @NotNull
    private final ScrapService scrapService;
    @NotNull
    private final Context context;

    @NotNull
    public final ScrapService getScrapService() {
        return this.scrapService;
    }

    public final void signUp(@NotNull String clientId, int birth, int gender) {
        Gender gender2;
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        switch (gender) {
            case 1: {
                gender2 = Gender.Male;
                break;
            }
            case 0: {
                gender2 = Gender.Female;
                break;
            }
            default: {
                gender2 = Gender.None;
            }
        }
        this.scrapService.signUp(clientId, birth, gender2, (Callback)new Callback<Response<Unit>>(){

            public void onDataLoaded(@NotNull Response<Unit> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void saveOfflineOrders(int mId, @NotNull List<? extends MartData> items) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        CommerceId commerceId = CommerceId.Companion.fromOfflineId(mId);
        if (commerceId == null) {
            return;
        }
        CommerceId commerceId2 = commerceId;
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            String string3;
            Branch branch;
            String string4;
            String string5;
            String string6;
            void it;
            MartData martData = (MartData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string7 = it.receiptKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it.receiptKey");
            String string8 = StringExtKt.toMD5((String)string7);
            Intrinsics.checkExpressionValueIsNotNull((Object)it.receiptKey, (String)"it.receiptKey");
            Double d = it.orderAmount;
            Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"it.orderAmount");
            Price price = new Price(d.doubleValue(), "KRW");
            String string9 = it.branchName;
            if (string9 == null) {
                string9 = "";
            }
            if ((string6 = it.branchAddress) == null) {
                string6 = "";
            }
            Branch branch2 = new Branch(string9, string6);
            String string10 = it.receiptProductKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"it.receiptProductKey");
            String string11 = StringExtKt.toMD5((String)string10);
            String string12 = it.barcode;
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"it.barcode");
            CharSequence charSequence = string12;
            String string13 = string11;
            Branch branch3 = branch2;
            Price price2 = price;
            CommerceId commerceId3 = commerceId2;
            String string14 = string8;
            boolean bl2 = false;
            boolean bl3 = charSequence.length() == 0;
            String string15 = StringExtKt.toMD5((String)(bl3 ? it.name + ";" + commerceId2.getId() : it.barcode + ";" + commerceId2.getId()));
            Intrinsics.checkExpressionValueIsNotNull((Object)it.name, (String)"it.name");
            Double d2 = it.price;
            Intrinsics.checkExpressionValueIsNotNull((Object)d2, (String)"it.price");
            Price price3 = new Price(d2.doubleValue(), "KRW");
            Intrinsics.checkExpressionValueIsNotNull((Object)it.barcode, (String)"it.barcode");
            Price price4 = price3;
            String string16 = string15;
            Product.Offline offline = new Product.Offline(string16, string5, price4, string4);
            int n = it.buyCount;
            Double d3 = it.price;
            Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"it.price");
            String string17 = "\uad6c\ub9e4\uc644\ub8cc";
            Price price5 = new Price(d3.doubleValue(), "KRW");
            int n2 = n;
            Product.Offline offline2 = offline;
            String string18 = string13;
            List list = CollectionsKt.listOf((Object)new OrderItem(string18, (Object)offline2, n2, price5, string17));
            String string19 = it.buyDate;
            Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"it.buyDate");
            long l = Utils.INSTANCE.convertDateTimeStrToCalendar(string19).getTimeInMillis();
            long l2 = System.currentTimeMillis();
            Intrinsics.checkExpressionValueIsNotNull((Object)it.raw, (String)"it.raw");
            Intrinsics.checkExpressionValueIsNotNull((Object)it.posNo, (String)"it.posNo");
            boolean bl4 = false;
            long l3 = l2;
            long l4 = l;
            List list2 = list;
            Branch branch4 = branch = branch3;
            String string20 = string3;
            String string21 = string2;
            boolean bl5 = bl4;
            long l5 = l3;
            long l6 = l4;
            List list3 = list2;
            Price price6 = price2;
            CommerceId commerceId4 = commerceId3;
            String string22 = string;
            String string23 = string14;
            OfflineDto offlineDto = new OfflineDto(string23, string22, commerceId4, price6, list3, l6, l5, bl5, string21, string20, branch4);
            collection.add(offlineDto);
        }
        List offlineItems = (List)destination$iv$iv;
        this.scrapService.saveOfflineOrders(offlineItems);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveOnlineOrders(int mId, @NotNull List<OrderEntity> items) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        CommerceId commerceId = CommerceId.Companion.fromOfflineId(mId);
        if (commerceId == null) {
            return;
        }
        CommerceId commerceId2 = commerceId;
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            void it;
            OrderEntity orderEntity = (OrderEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it.orderNum;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.orderNum");
            String orderId = StringExtKt.toMD5((String)string3);
            String string4 = it.detailProductLink;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.detailProductLink");
            CharSequence charSequence = string4;
            boolean bl2 = false;
            String string5 = charSequence.length() == 0 ? it.title + ";" + commerceId2.getId() : it.detailProductLink;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(if(it.detailProductLink\u2026{ it.detailProductLink })");
            String productId = StringExtKt.toMD5((String)string5);
            String orderItemId = StringExtKt.toMD5((String)(orderId + productId));
            String string6 = it.orderNum;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.orderNum");
            double d = it.price;
            String string7 = it.currency;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it.currency");
            Price price = new Price(d, string7);
            String string8 = it.title;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"it.title");
            double d2 = it.price;
            String string9 = it.currency;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"it.currency");
            Price price2 = new Price(d2, string9);
            List list = CollectionsKt.listOf((Object)it.orderOption);
            String string10 = it.imgUrl;
            String string11 = it.imgUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"it.imgUrl");
            Image image = new Image(string10, string11);
            Intrinsics.checkExpressionValueIsNotNull((Object)it.detailProductLink, (String)"it.detailProductLink");
            String string12 = null;
            Image image2 = image;
            Product.Online online = new Product.Online(productId, string8, price2, list, string12, image2, string2);
            int n = it.quantity;
            double d3 = it.price;
            String string13 = it.currency;
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"it.currency");
            Price price3 = new Price(d3, string13);
            String string14 = it.orderState;
            Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"it.orderState");
            List list2 = CollectionsKt.listOf((Object)new OrderItem(orderItemId, (Object)online, n, price3, string14));
            Date date = it.orderDate;
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"it.orderDate");
            long l = date.getTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)it.detailOrderLink, (String)"it.detailOrderLink");
            bl2 = false;
            long l2 = System.currentTimeMillis();
            OnlineDto onlineDto = new OnlineDto(orderId, string6, commerceId2, price, list2, l, bl2, string, l2);
            collection.add(onlineDto);
        }
        List onlineItems = (List)destination$iv$iv;
        this.scrapService.saveOnlineOrders(onlineItems);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public CommerceManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        String apiKey = "";
        String layer = "";
        apiKey = "Nrcoz4wo1Z8mvEuyZzcFt3QUu3cCKpjC4TtijITZ";
        layer = "prod";
        this.scrapService = new ScrapBuilder().with(this.context).apiKey(apiKey).layer(layer).hour(0).logger(true).build();
    }
}

