/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.SparseArray;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.MallViewHandler;
import com.tenqube.visual_scraper.ParameterException;
import com.tenqube.visual_scraper.ScrapManager;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.LoadingState;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.query.Password;
import com.tenqube.visual_scraper.model.view.MallInfo;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.model.view.UserMall;
import com.tenqube.visual_scraper.model.view.ViewMoreInfo;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.thirdparty.commerce.CommerceManager;
import com.tenqube.visual_scraper.thirdparty.market.MarketScrapper;
import com.tenqube.visual_scraper.thirdparty.market.MarketScrapperImpl;
import com.tenqube.visual_scraper.thirdparty.mart.MartScrapper;
import com.tenqube.visual_scraper.thirdparty.mart.MartScrapperImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import timber.log.Timber;

public class ScrapServiceImpl
implements ScrapService {
    public Context context;
    private ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager mWebViewManager;
    private ScrapService.DataInteraction dataInteraction;
    public static Locale locale;
    private ScrapManager scrapManager;
    private MartScrapper martScrapper;
    private MarketScrapper marketScrapper;
    private SparseArray<LoadingState> progressStateArray = new SparseArray();
    private Handler handler;
    private CommerceManager commerceManager;

    public ScrapServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier, @NonNull ScrapService.DataInteraction dataInteraction) throws ParameterException {
        if (context == null) {
            throw new ParameterException("context is null");
        }
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new ParameterException("apiKey is empty");
        }
        if (TextUtils.isEmpty((CharSequence)qualifier)) {
            throw new ParameterException("qualifier is empty");
        }
        if (dataInteraction == null) {
            throw new ParameterException("dataInteraction is empty");
        }
        this.context = context;
        this.dataInteraction = dataInteraction;
        this.initLocale();
        this.preferences = Injection.provideSharedPreference(context);
        this.preferences.edit().putString("layer", qualifier).apply();
        this.commerceManager = new CommerceManager(context);
        this.repository = Injection.provideScrapRepository(context.getApplicationContext(), this.preferences);
        this.repository.saveKey(apiKey);
        this.handler = this.createHandler();
        this.scrapManager = ScrapManager.getInstance(context, this.repository, this.commerceManager, this.handler);
        this.martScrapper = MartScrapperImpl.getInstance(context);
        this.marketScrapper = new MarketScrapperImpl(context);
        this.singUp();
        this.syncRule(null);
    }

    private void singUp() {
        this.commerceManager.signUp(this.dataInteraction.getUid(), this.dataInteraction.getBirth(), this.dataInteraction.getGender());
        if (!this.preferences.getString("uuid", "").equals(this.dataInteraction.getUid())) {
            this.dataInteraction.getAdId(adId -> {
                String appName = this.dataInteraction.getServiceAppName();
                if (TextUtils.isEmpty((CharSequence)appName)) {
                    return;
                }
                String uid = this.dataInteraction.getUid();
                if (TextUtils.isEmpty((CharSequence)uid)) {
                    return;
                }
                this.repository.signUpUser(appName, uid, (String)adId, items -> {
                    Timber.i((String)"appName :%s", (Object[])new Object[]{appName});
                    Timber.i((String)"uid: %s", (Object[])new Object[]{uid});
                    Timber.i((String)"adId: %s", (Object[])new Object[]{adId});
                });
            });
        }
    }

    private void initLocale() {
        locale = Build.VERSION.SDK_INT >= 24 ? this.context.getResources().getConfiguration().getLocales().get(0) : this.context.getResources().getConfiguration().locale;
    }

    @Override
    public void initialize() {
        this.repository.initialize();
    }

    @Override
    public void destroy() {
        this.progressStateArray.clear();
    }

    @Override
    public WebView getWebView() {
        return this.mWebViewManager.getWebView();
    }

    @Override
    public void requestMobileAuthCode(String phoneNumber, String birth, String name, ScrapService.OnResultCallback<Boolean> onResult) throws Exception {
        this.martScrapper.init(items -> {
            try {
                this.martScrapper.requestMobileAuthCode(phoneNumber, birth, name, (Boolean success) -> onResult.onDataLoaded((Boolean)success));
            }
            catch (Exception e) {
                e.printStackTrace();
                onResult.onDataLoaded(false);
            }
        });
    }

    @Override
    public void getUserMalls(ScrapService.onResultInterface<List<UserMall>> onResult) throws Exception {
        try {
            this.repository.getMallWithActiveUsers(items -> {
                ArrayList<UserMall> users = new ArrayList<UserMall>();
                for (MallWithUser mallUser : items) {
                    MallInfo mall = new MallInfo(mallUser.mall.getId(), mallUser.mall.getDisplayName(), mallUser.mall.getIconUrl());
                    users.add(new UserMall(mall, mallUser.user.getUserId(), mallUser.user.getUserPwd().getValue()));
                }
                onResult.onDataLoaded(users);
            });
        }
        catch (Exception e) {
            onResult.onFail();
        }
    }

    @Override
    public void startHomeplusLogin(String authCode, String phoneNumber, ScrapService.OnResultCallback<Boolean> onResult) throws Exception {
        try {
            this.martScrapper.startHomeplusLogin(authCode, phoneNumber, onResult::onDataLoaded);
        }
        catch (Exception e) {
            e.printStackTrace();
            onResult.onDataLoaded(false);
        }
    }

    @Override
    public void startLoginAndParsing(final String userId, final String userPwd, final int mId, final MallViewHandler mallViewService, final ScrapService.OnResultCallback<Integer> onResult) throws ParameterException {
        Timber.i((String)("startLoginAndParsing = " + userId + "/" + mId + "/" + userPwd), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)userPwd) || mId == 0) {
            throw new ParameterException("empty parameter");
        }
        this.progressStateArray.put(mId, (Object)new LoadingState(true));
        this.repository.checkIsActiveMall(mId, mall -> {
            Timber.i((String)"checkIsActiveMall : %s %s", (Object[])new Object[]{mId, mall});
            if (mall == null) {
                onResult.onFail(mId, Constants.ERROR.EMPTY_MALL, "empty mall");
                return;
            }
            Timber.i((String)"checkIsActiveMall : !!", (Object[])new Object[0]);
            this.scrapManager.setCallback(new ScrapService.OnResultCallback<Integer>(){

                @Override
                public void onDataLoaded(Integer item) {
                    ScrapServiceImpl.this.progressStateArray.put(mId, (Object)new LoadingState(false));
                    onResult.onDataLoaded(item);
                }

                @Override
                public void onFail(int mId2, Constants.ERROR error, String msg) {
                    ScrapServiceImpl.this.progressStateArray.put(mId2, (Object)new LoadingState(false));
                    onResult.onFail(mId2, error, msg);
                }
            });
            this.repository.getMallWithUser(mId, userId, new ScrapService.onResultInterface<MallWithUser>(){

                @Override
                public void onDataLoaded(MallWithUser item) {
                    Timber.i((String)"item : %s", (Object[])new Object[]{item});
                    MallWithUser mallWithUser = new MallWithUser(item.mall, new UserEntity(mId, userId, new Password(userPwd)));
                    ScrapServiceImpl.this.startScrap(mId, mallWithUser, mallViewService, ScrapServiceImpl.this.martScrapper, ScrapServiceImpl.this.marketScrapper, false);
                }

                @Override
                public void onFail() {
                    Timber.i((String)"mId : %s", (Object[])new Object[]{mId});
                    MallWithUser mallWithUser = new MallWithUser(mall, new UserEntity(mId, userId, new Password(userPwd)));
                    ScrapServiceImpl.this.startScrap(mId, mallWithUser, mallViewService, ScrapServiceImpl.this.martScrapper, ScrapServiceImpl.this.marketScrapper, false);
                }
            });
        });
    }

    private void startScrap(int mId, MallWithUser mallWithUser, MallViewHandler mallViewService, MartScrapper martScrapper, MarketScrapper marketScrapper, boolean isLoginSkip) {
        Constants.MALL mall = Constants.MALL.fromMallId(mId);
        if (mall != null) {
            switch (mall) {
                case Emart: 
                case LotteMart: 
                case Homeplus: {
                    this.startScrap(mallWithUser, martScrapper, isLoginSkip);
                    break;
                }
                case Coupang: 
                case Gmarket: 
                case SSG: 
                case MarketKurly: {
                    this.startScrap(mallWithUser, marketScrapper, isLoginSkip);
                    break;
                }
                default: {
                    this.startScrap(mallWithUser, this.createWebViewManager(mallViewService), isLoginSkip);
                }
            }
        }
    }

    private WebViewManager createWebViewManager(@Nullable MallViewHandler mallViewService) {
        this.mWebViewManager = new WebViewManager(this.context, mallViewService);
        return this.mWebViewManager;
    }

    private void startScrap(MallWithUser mallWithUser, MartScrapper martScrapper, boolean isLoginSkip) {
        this.scrapManager.startScrap(mallWithUser, martScrapper, isLoginSkip);
    }

    private void startScrap(MallWithUser mallWithUser, MarketScrapper marketScrapper, boolean isLoginSkip) {
        this.scrapManager.startScrap(mallWithUser, marketScrapper, isLoginSkip);
    }

    private void startScrap(MallWithUser mallWithUser, WebViewManager webViewManager, boolean isLoginSkip) {
        this.scrapManager.startScrap(mallWithUser, webViewManager, isLoginSkip);
    }

    private Handler createHandler() {
        return new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Constants.ScrapState value = Constants.ScrapState.values()[msg.what];
                Bundle bundle = msg.getData();
                String errMsg = bundle.getString("msg");
                int mallId = bundle.getInt("mallId");
                int errorCode = bundle.getInt("error");
                Constants.ERROR error = Constants.ERROR.values()[errorCode];
                ScrapServiceImpl.this.progressStateArray.put(mallId, (Object)new LoadingState(false));
            }
        };
    }

    @Override
    public void startParsingMalls() {
        this.syncRule(null);
        Timber.i((String)"parsing checkDiffTime true", (Object[])new Object[0]);
        this.preferences.edit().putLong("CHECK_PARSING_TIME", System.currentTimeMillis()).apply();
        this.repository.getMallWithActiveUsers(items -> {
            Timber.i((String)("getMallsAndParsingitem : " + items), (Object[])new Object[0]);
            for (MallWithUser mallWithUser : items) {
                this.startScrap(mallWithUser.mall.getId(), mallWithUser, null, this.martScrapper, this.marketScrapper, true);
                Timber.i((String)("getMallsAndParsingmallWithUser : " + mallWithUser), (Object[])new Object[0]);
            }
        });
    }

    private void syncRule(@Nullable ScrapService.onResultInterface<Void> callback) {
        this.repository.syncRule(callback);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.preferences.edit().putBoolean("SDK_IS_ENABLE", enabled).apply();
    }

    @Override
    public void getOrderList(int limit, ViewMoreInfo viewMoreInfo, ScrapService.OnResultCallback<List<OrderInfo>> callback) {
        this.repository.getOrderList(limit, viewMoreInfo, callback::onDataLoaded);
    }

    @Override
    public void getMallWithUsers(final ScrapService.Callback<List<MallWithUser>> callback) {
        this.syncRule(new ScrapService.onResultInterface<Void>(){

            @Override
            public void onDataLoaded(Void item) {
                ScrapServiceImpl.this.loadMalls(callback);
            }

            @Override
            public void onFail() {
                ScrapServiceImpl.this.loadMalls(callback);
            }
        });
    }

    private void loadMalls(ScrapService.Callback<List<MallWithUser>> callback) {
        this.repository.getMallWithUser(items -> {
            for (MallWithUser mallWithUser : items) {
                LoadingState loadingState = (LoadingState)this.progressStateArray.get(mallWithUser.mall.getId());
                boolean isLoading = loadingState != null && loadingState.isLoading();
                mallWithUser.setProgress(isLoading);
            }
            callback.onDataLoaded((List<MallWithUser>)items);
        });
    }

    @Override
    public void signOut(int mId, ScrapService.OnResultCallback<Void> callback) {
        this.logout(mId);
        this.repository.deleteOrderByMallIds(mId);
        this.repository.deleteUsersByMallId(mId);
        if (callback != null) {
            callback.onDataLoaded(null);
        }
    }

    private void logout(final int mId) {
        Constants.MALL mall = Constants.MALL.fromMallId(mId);
        if (mall != null) {
            switch (mall) {
                case Emart: 
                case LotteMart: 
                case Homeplus: {
                    this.repository.getMallWithActiveUser(mId, new ScrapService.Callback<MallWithUser>(){

                        @Override
                        public void onDataLoaded(MallWithUser item) {
                            if (item != null && item.user != null) {
                                ScrapServiceImpl.this.martScrapper.logout(mId, item.user.getUserId());
                            }
                        }
                    });
                    break;
                }
                case SSG: 
                case MarketKurly: {
                    this.marketScrapper.logout(mId);
                    break;
                }
                default: {
                    this.scrapManager.logout(mId);
                }
            }
        }
    }

    @Override
    public void hideOrder(int orderId) {
        this.repository.hideOrder(orderId);
    }

    @Override
    public void deleteOrder(int orderId) {
        this.repository.deleteOrder(orderId);
    }

    @Override
    public void deleteOrdersByOrderIds(int ... orderIds) {
        this.repository.deleteOrders(orderIds);
    }

    @Override
    public void deleteAllOrders() {
        this.repository.deleteAllOrders();
    }

    @Override
    public void deleteOrderByMallIds(int ... mIds) {
        this.repository.deleteOrderByMallIds(mIds);
    }

    @Override
    public void insertUserEntity(UserEntity userEntity) {
        this.repository.insertUsers(userEntity, null);
    }

    @Override
    public void setParsingFrequency(int frequency) {
        this.preferences.edit().putInt("PARSING_FREQUENCY", frequency).apply();
    }

    @Override
    public void getLastOrderId(ScrapService.Callback<Integer> callback) {
        this.repository.getLastOrderId(callback);
    }
}

