/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.utils;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AppExecutors {
    private final Executor mDiskIO;
    private final Executor mNetworkIO;
    private final Executor mMainThread;

    private AppExecutors(Executor diskIO, Executor networkIO, Executor mainThread) {
        this.mDiskIO = diskIO;
        this.mNetworkIO = networkIO;
        this.mMainThread = mainThread;
    }

    public AppExecutors() {
        this(Executors.newSingleThreadExecutor(), Executors.newFixedThreadPool(3), new MainThreadExecutor());
    }

    public Executor diskIO() {
        return this.mDiskIO;
    }

    public Executor networkIO() {
        return this.mNetworkIO;
    }

    public Executor mainThread() {
        return this.mMainThread;
    }

    private static class MainThreadExecutor
    implements Executor {
        private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

