/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Wemake
extends Mall {
    String URL = "http://www.wemakeprice.com";

    public Wemake(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    public String getBaseUrl() {
        return "http://www.wemakeprice.com/";
    }

    @Override
    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        ArrayList<OrderHtml> orderHtmls = new ArrayList<OrderHtml>();
        OrderHtml beforeHtml = null;
        try {
            for (Element e : elements) {
                OrderHtml currentHtml = this.parseHtml(e, beforeHtml);
                orderHtmls.add(currentHtml);
                beforeHtml = currentHtml;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderHtmls;
    }

    private OrderHtml parseHtml(Element element, OrderHtml beforeHtml) {
        OrderHtml order2 = new OrderHtml();
        order2.title = this.parseValue(element, this.orderWebRule.getTitle());
        order2.orderDate = this.parseValue(element, this.orderWebRule.getOrderDate());
        order2.orderHms = this.parseValue(element, this.orderWebRule.getOrderHms());
        order2.orderOption = this.parseValue(element, this.orderWebRule.getOrderOption());
        order2.quantity = this.parseValue(element, this.orderWebRule.getQuantity());
        order2.price = this.parseValue(element, this.orderWebRule.getPrice());
        order2.orderNum = this.parseValue(element, this.orderWebRule.getOrderNum());
        order2.orderState = this.parseValue(element, this.orderWebRule.getOrderState());
        order2.imgUrl = this.parseValue(element, this.orderWebRule.getImgUrl());
        order2.detailOrderLink = this.parseValue(element, this.orderWebRule.getDetailOrderLink());
        order2.detailProdLink = this.parseValue(element, this.orderWebRule.getDetailProductLink());
        if (beforeHtml != null && TextUtils.isEmpty((CharSequence)order2.orderNum)) {
            order2.orderDate = beforeHtml.orderDate;
            order2.orderNum = beforeHtml.orderNum;
            order2.detailOrderLink = beforeHtml.detailOrderLink;
            order2.orderState = beforeHtml.orderState;
        }
        if (TextUtils.isEmpty((CharSequence)order2.title) || TextUtils.isEmpty((CharSequence)order2.orderNum)) {
            return null;
        }
        return order2;
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty((CharSequence)orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10) : "";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected String orderOptionFilter(@NonNull String orderOption) {
        return orderOption.replace("\t", "").replace("\n", "");
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        try {
            if (!TextUtils.isEmpty((CharSequence)orderNum) && orderNum.length() > 1) {
                return orderNum.substring(orderNum.indexOf("(") + 1, orderNum.indexOf(")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            String[] quantityStrArray;
            if (!TextUtils.isEmpty((CharSequence)quantity) && (quantityStrArray = quantity.split("/")).length > 1) {
                return Integer.parseInt(quantityStrArray[1].replace("]", "").replace("\uac1c", "").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public String getLogoutUrl() {
        return "javascript:document.querySelector('#_logOutBtn').click();";
    }
}

