package com.tenqube.visual_scraper.webviewhtmlloader.model

import android.os.Parcel
import android.os.Parcelable

data class ScrapingUrl(val path: String, val isJs: Boolean, val hasHtml: Boolean) : Parcelable {
    constructor(parcel: Parcel) : this(
            parcel.readString(),
            parcel.readByte() != 0.toByte(),
            parcel.readByte() != 0.toByte()) {
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(path)
        parcel.writeByte(if (isJs) 1 else 0)
        parcel.writeByte(if (hasHtml) 1 else 0)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<ScrapingUrl> {
        override fun createFromParcel(parcel: Parcel): ScrapingUrl {
            return ScrapingUrl(parcel)
        }

        override fun newArray(size: Int): Array<ScrapingUrl?> {
            return arrayOfNulls(size)
        }
    }
}