package com.tenqube.visual_scraper.mall;


import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import timber.log.Timber;

public class Tmon extends Mall {

    public Tmon(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        List<OrderHtml> orderHtmls = new ArrayList<>();
        int i;
        try {
            if (!TextUtils.isEmpty(orderWebRule.getTitle().equation)) {
                List<String> title = parseEquation(elements, orderWebRule.getTitle());
                List<String> orderDate = parseEquation(elements, orderWebRule.getOrderDate());
                List<String> orderHms = parseEquation(elements, orderWebRule.getOrderHms());
                List<String> orderOption = parseEquation(elements, orderWebRule.getOrderOption());
                List<String> quantity = parseEquation(elements, orderWebRule.getQuantity());
                List<String> price = parseEquation(elements, orderWebRule.getPrice());
                List<String> orderNum = parseEquation(elements, orderWebRule.getOrderNum());
                List<String> orderState = parseEquation(elements, orderWebRule.getOrderState());
                List<String> imgUrl = parseEquation(elements, orderWebRule.getImgUrl());
                List<String> detailOrderLink = parseEquation(elements, orderWebRule.getDetailOrderLink());
                List<String> detailProdLink = parseEquation(elements, orderWebRule.getDetailProductLink());


                for (i=0; i < title.size(); i++) {
                    OrderHtml orderHtml = new OrderHtml();

                    orderHtml.title = title.get(i);
                    orderHtml.orderDate = orderDate.get(i);
                    orderHtml.orderHms = orderHms == null ? "" : orderHms.get(i);
                    orderHtml.orderOption = orderOption == null ? "" : orderOption.get(i);
                    orderHtml.quantity = quantity == null ? "" : quantity.get(i);
                    orderHtml.price = price.get(i);
                    orderHtml.orderNum = orderNum.get(i);
                    orderHtml.orderState = orderState == null ? "" : orderState.get(i);
                    orderHtml.imgUrl = imgUrl == null ? "" : imgUrl.get(i);
                    orderHtml.detailOrderLink = detailOrderLink == null ? "" : detailOrderLink.get(i);
                    orderHtml.detailProdLink = detailProdLink == null ? "" : detailProdLink.get(i);

                    Timber.i("parseWeb"+"parsed_orderHtml : "+ orderHtml);
                    orderHtmls.add(orderHtml);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return orderHtmls;
    }

    private List<String> parseEquation(Elements elements, ParsingOrderRules parsingOrderRules) {
        List<String> results = new ArrayList<>();
        if (parsingOrderRules != null) {
            String key = String.format(parsingOrderRules.selector, parsingOrderRules.equation);
            parsingOrderRules.selector = key;
            Elements elements1 = elements.select(key);
            Timber.i("Tmon"+"parseEquation_size : "+elements.size());
            for (Element e : elements1) {
                String result = "";
                if (TextUtils.isEmpty(parsingOrderRules.attribute)) {
                    result = e.text();
                } else {
                    if (parsingOrderRules.attribute.contains("href")) {
                        result = e.absUrl("href");
                    } else {
                        result = e.attr(parsingOrderRules.attribute);
                    }
                }
                Timber.i("Tmon"+"result : "+result);
                results.add(result);
            }
        } else {
            return null;
        }
        return results;
    }

    @Override
    public boolean identifyLoginPageOrNot(String url) {
        return url != null && url.contains("https://login.tmon.co.kr/user/loginform?message=login_fail");
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.DOT);
    }

    @Override
    protected Date orderHmsFilter(@NonNull String orderHms) {
        return DateUtils.transformHms(orderHms
                .replace("(","")
                .replace(")", ""));
    }

    @Override
    protected String orderStateFilter(@NonNull String orderState) {
        try {
//            if (!TextUtils.isEmpty(orderState) && !orderState.equals("환불완료"))
//                return "사용";
            if (!TextUtils.isEmpty(orderState)) {
                String[] s = orderState.split("\\|");
                if (s.length > 1) {
                    return s[1].replace(")","").trim();
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }


    @Override
    protected boolean checkLoginPageOrNot(String url) {
        if (url.contains("https://login.tmon.co.kr")) {
            return false;
        }
        return url.contains("Login") || url.contains("login");
    }
}
