/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import timber.log.Timber;

public class Tmon
extends Mall {
    public Tmon(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        ArrayList<OrderHtml> orderHtmls = new ArrayList<OrderHtml>();
        try {
            if (!TextUtils.isEmpty((CharSequence)orderWebRule.getTitle().equation)) {
                List<String> title = this.parseEquation(elements, orderWebRule.getTitle());
                List<String> orderDate = this.parseEquation(elements, orderWebRule.getOrderDate());
                List<String> orderHms = this.parseEquation(elements, orderWebRule.getOrderHms());
                List<String> orderOption = this.parseEquation(elements, orderWebRule.getOrderOption());
                List<String> quantity = this.parseEquation(elements, orderWebRule.getQuantity());
                List<String> price = this.parseEquation(elements, orderWebRule.getPrice());
                List<String> orderNum = this.parseEquation(elements, orderWebRule.getOrderNum());
                List<String> orderState = this.parseEquation(elements, orderWebRule.getOrderState());
                List<String> imgUrl = this.parseEquation(elements, orderWebRule.getImgUrl());
                List<String> detailOrderLink = this.parseEquation(elements, orderWebRule.getDetailOrderLink());
                List<String> detailProdLink = this.parseEquation(elements, orderWebRule.getDetailProductLink());
                for (int i = 0; i < title.size(); ++i) {
                    OrderHtml orderHtml = new OrderHtml();
                    orderHtml.title = title.get(i);
                    orderHtml.orderDate = orderDate.get(i);
                    orderHtml.orderHms = orderHms == null ? "" : orderHms.get(i);
                    orderHtml.orderOption = orderOption == null ? "" : orderOption.get(i);
                    orderHtml.quantity = quantity == null ? "" : quantity.get(i);
                    orderHtml.price = price.get(i);
                    orderHtml.orderNum = orderNum.get(i);
                    orderHtml.orderState = orderState == null ? "" : orderState.get(i);
                    orderHtml.imgUrl = imgUrl == null ? "" : imgUrl.get(i);
                    orderHtml.detailOrderLink = detailOrderLink == null ? "" : detailOrderLink.get(i);
                    orderHtml.detailProdLink = detailProdLink == null ? "" : detailProdLink.get(i);
                    Timber.i((String)("parseWebparsed_orderHtml : " + orderHtml), (Object[])new Object[0]);
                    orderHtmls.add(orderHtml);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderHtmls;
    }

    private List<String> parseEquation(Elements elements, ParsingOrderRules parsingOrderRules) {
        ArrayList<String> results = new ArrayList<String>();
        if (parsingOrderRules != null) {
            String key;
            parsingOrderRules.selector = key = String.format(parsingOrderRules.selector, parsingOrderRules.equation);
            Elements elements1 = elements.select(key);
            Timber.i((String)("TmonparseEquation_size : " + elements.size()), (Object[])new Object[0]);
            for (Element e : elements1) {
                String result = "";
                result = TextUtils.isEmpty((CharSequence)parsingOrderRules.attribute) ? e.text() : (parsingOrderRules.attribute.contains("href") ? e.absUrl("href") : e.attr(parsingOrderRules.attribute));
                Timber.i((String)("Tmonresult : " + result), (Object[])new Object[0]);
                results.add(result);
            }
        } else {
            return null;
        }
        return results;
    }

    @Override
    public boolean identifyLoginPageOrNot(String url) {
        return url != null && url.contains("https://login.tmon.co.kr/user/loginform?message=login_fail");
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.DOT);
    }

    @Override
    protected Date orderHmsFilter(@NonNull String orderHms) {
        return DateUtils.transformHms(orderHms.replace("(", "").replace(")", ""));
    }

    @Override
    protected String orderStateFilter(@NonNull String orderState) {
        try {
            String[] s;
            if (!TextUtils.isEmpty((CharSequence)orderState) && (s = orderState.split("\\|")).length > 1) {
                return s[1].replace(")", "").trim();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        if (url.contains("https://login.tmon.co.kr")) {
            return false;
        }
        return url.contains("Login") || url.contains("login");
    }
}

