package com.tenqube.visual_scraper.mall;


import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Gmarket extends Mall {

    public Gmarket(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty(orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10):"";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {

        if (!TextUtils.isEmpty(quantity)) {

            Pattern pattern = Pattern.compile("\\s*수량\\s*:\\s*(\\d+)개\\s*/\\s*주문번호\\s*:\\s*\\S+\\s*", Pattern.CASE_INSENSITIVE|Pattern.DOTALL);
            Matcher matcher = pattern.matcher(quantity.charAt(0)+"");
            if (matcher.matches()){
                return Integer.parseInt(matcher.group(1));
            }
        }
        return 1;
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        if (!TextUtils.isEmpty(orderNum)) {

            Pattern pattern = Pattern.compile("\\s*주문번호\\s*(\\S+)\\s*", Pattern.CASE_INSENSITIVE|Pattern.DOTALL);
            Matcher matcher = pattern.matcher(orderNum);
            if (matcher.matches()){
                return matcher.group(1);
            }
        }
        return "";
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        /**
         * http://gdimg.gmarket.co.kr/1483269999/still/160?ver=0
         */

        return super.imgUrlFilter(imgUrl);
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        /**
         * success
         *  http://mobile.gmarket.co.kr/
         *
         *
         *  fail
         *  https://mobile.gmarket.co.kr/Login/Login
         *  https://mobile.gmarket.co.kr/Login
         */



        return super.checkLoginPageOrNot(url);
    }
}
