/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.Date;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import timber.log.Timber;

public class LotteHome
extends Mall {
    public LotteHome(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        return TextUtils.isEmpty((CharSequence)orderNum) ? orderNum : orderNum.replaceAll("-", "");
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty((CharSequence)orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10) : "";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            String[] quantityStrArray;
            if (!TextUtils.isEmpty((CharSequence)quantity) && (quantityStrArray = quantity.split("/")).length > 1) {
                return Integer.parseInt(quantityStrArray[1].replace("\uac1c", "").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        return url.contains("https://secure.lotteimall.com/member/goLogin.lotte") || url.contains("https://secure.lotteimall.com/member/login/forward.LCLoginMem.lotte") || url.contains("https://members.lpoint.com/exView/manage/fdPassword") || url.contains("login");
    }

    @Override
    protected boolean checkCaptchaClass(Document document) {
        Elements elements = document.select(this.loginWebRule.getCaptchaContainer().selector);
        if (elements.size() == 0) {
            elements = document.select("#catpcha_view_area");
        }
        Timber.i((String)("checkCaptchaClasssize : " + elements.size() + "/container : " + this.loginWebRule.getCaptchaContainer()), (Object[])new Object[0]);
        return elements.size() != 0;
    }

    @Override
    protected boolean passFinishedWebPages(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && (url.contains("http://www.lotteimall.com/member/forward.LCSSOGate.lotte?call_screen=pwfindfive") || url.contains("http://www.lotteimall.com/?ccoDlyMsg=chlNo") || url.contains("http://www.lotteimall.com/member/login/forward.LCSSOLogin_proc.lotte"));
    }

    @Override
    protected boolean showWebViewOrNot(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && url.contains("https://members.lpoint.com/exView/manage/fdPassword_01_001");
    }
}

