/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.text.TextUtils;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.DateUtils;
import com.tenqube.visual_scraper.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import timber.log.Timber;

public class Mall {
    private AppExecutors appExecutors;
    LoginWebRule loginWebRule;
    OrderWebRule orderWebRule;
    OrderDetailWebRuleJson orderDetailWebRuleJson;
    OrderApiRuleJson orderApiRuleJson;
    final ScrapRepository repository;
    private WebViewManager webViewManager;
    public MallData mallData;

    public Mall(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        this.mallData = mallData;
        this.repository = repository;
        this.appExecutors = new AppExecutors();
        this.webViewManager = webViewManager;
    }

    public void startWebViewLogin(@NonNull LoginWebRule loginWebRule, final @NonNull UserEntity user, final boolean shouldInsert, final @NonNull ScrapService.OnResult<List<OrderEntity>> onResult) {
        Utils.getFinalLoginWebRule(loginWebRule, user.getUserId(), user.getUserPwd().getValue());
        this.loginWebRule = loginWebRule;
        this.webViewManager.setWebUrl(loginWebRule.getUrl().finalQuery).setScripts(loginWebRule.getLoginScripts().finalQuery).setAction(1).build(new WebViewManager.WebViewCallback(){

            @Override
            public void onResult(String cookie, WebView webView) {
                Timber.i((String)("startWebViewLoginlogin Success : cookie " + cookie + "/" + webView), (Object[])new Object[0]);
                if (shouldInsert) {
                    user.setLogin(true);
                    Timber.i((String)("insertUseruser : " + user), (Object[])new Object[0]);
                    Mall.this.repository.insertUsers(user, uId -> {
                        user.setId((int)uId);
                        Mall.this.startOrder(user, cookie, onResult);
                    });
                } else {
                    Mall.this.startOrder(user, cookie, onResult);
                }
            }

            @Override
            public void onFail(int statusCode, String statusMessage) {
                Timber.i((String)("login_webonFail : " + statusCode + "/" + statusMessage), (Object[])new Object[0]);
                onResult.onFail(user.getMallId(), Constants.ERROR.LOGIN_FAIL, statusMessage);
            }
        });
    }

    private void startOrder(UserEntity user, String cookie, @NonNull ScrapService.OnResult<List<OrderEntity>> onResult) {
        this.repository.getOrderWebRule(user.getMallId(), webRule -> {
            Timber.i((String)("getOrderWebRuleinfo : " + webRule), (Object[])new Object[0]);
            if (webRule != null) {
                this.orderWebRule = webRule;
                if (this.orderWebRule.getUrl() != null) {
                    this.orderWebRule.getUrl().finalQuery = Utils.getOrderValue(this.orderWebRule.getUrl(), user.getLastScrapAt());
                }
                if (this.orderWebRule.getPeriodScripts() != null) {
                    this.orderWebRule.getPeriodScripts().finalQuery = Utils.getOrderValue(this.orderWebRule.getPeriodScripts(), user.getLastScrapAt());
                }
                Timber.i((String)("getOrderWebRulefinal_info : " + this.orderWebRule), (Object[])new Object[0]);
                this.repository.getDetailHtmlRule(user.getMallId(), detailWebRule -> {
                    this.orderDetailWebRuleJson = detailWebRule;
                    this.parseWeb(user, cookie, onResult, items -> {
                        Timber.i((String)("parseWebitems : " + items), (Object[])new Object[0]);
                        if (items != null && items.size() != 0) {
                            this.repository.isExistUser(user.getId(), isExist -> {
                                if (isExist.booleanValue()) {
                                    this.repository.insertOrders((List<OrderEntity>)items, insertedList -> {
                                        Timber.i((String)("successitem :" + items.size() + "/" + insertedList.size()), (Object[])new Object[0]);
                                        onResult.onSuccess(user.getMallId(), (List<OrderEntity>)insertedList, this.mallData.getDisplayName() + " \uac2f\uc218 : " + insertedList.size());
                                    });
                                } else {
                                    onResult.onSuccess(user.getMallId(), null, this.mallData.getDisplayName() + "/ \ub85c\uadf8\uc544\uc6c3");
                                }
                            });
                        } else {
                            onResult.onSuccess(user.getMallId(), null, this.mallData.getDisplayName() + "/\uad6c\ub9e4\ub0b4\uc5ed\uc5c6\uc74c");
                        }
                    });
                });
            } else {
                onResult.onFail(user.getMallId(), Constants.ERROR.NOT_FOUND_RULE, this.mallData.getDisplayName() + " login_web");
            }
        });
    }

    private void parseWeb(final UserEntity user, String cookie, final ScrapService.OnResult onResult, final ScrapService.Callback<List<OrderEntity>> callback) {
        final ArrayList orders = new ArrayList();
        Runnable runnable = () -> this.getOrderPageDocument(cookie, this.orderWebRule, new OrderCallback<Document>(){

            @Override
            public void onResult(Document document) {
                List orderHtmls = Mall.this.convertToOrderHtmlList(document);
                Timber.i((String)("parseWeborderHtmls size : " + orderHtmls.size() + " orderHtmls : " + orderHtmls), (Object[])new Object[0]);
                orders.addAll(Mall.this.convertToOrderEntity(orderHtmls, Mall.this.orderDetailWebRuleJson));
                long lastScrapAt = Utils.getLastScrapAt();
                Mall.this.repository.updateUserLastScrapAt(lastScrapAt, user.getMallId(), user.getUserId());
                Mall.this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(orders));
            }

            @Override
            public void onFail(int statusCode, String statusMessage) {
                Mall.this.appExecutors.mainThread().execute(() -> onResult.onFail(user.getMallId(), Constants.ERROR.PARSING_FAIL, Mall.this.mallData.getDisplayName() + statusMessage));
            }
        });
        this.appExecutors.networkIO().execute(runnable);
    }

    private List<OrderHtml> convertToOrderHtmlList(Document document) {
        Elements elements = this.getElements(document, this.orderWebRule);
        ArrayList<OrderHtml> orderHtmls = new ArrayList<OrderHtml>(this.getOrderHtmls(elements, this.orderWebRule));
        if (orderHtmls.size() == 0 && !TextUtils.isEmpty((CharSequence)this.orderWebRule.getContainer().equation)) {
            elements = document.select(String.format(this.orderWebRule.getContainer().selector, "n"));
            orderHtmls.addAll(this.getOrderHtmls(elements, this.orderWebRule));
        }
        return orderHtmls;
    }

    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        ArrayList<OrderHtml> orderHtmls = new ArrayList<OrderHtml>();
        Timber.i((String)("parseWebelement_size : " + elements.size()), (Object[])new Object[0]);
        for (Element element : elements) {
            try {
                OrderHtml orderHtml = this.parseHtml(element);
                if (orderHtml == null) continue;
                orderHtmls.add(orderHtml);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return orderHtmls;
    }

    private Elements getElements(Document document, OrderWebRule orderWebRule) {
        Elements elements = TextUtils.isEmpty((CharSequence)orderWebRule.getContainer().equation) ? document.select(orderWebRule.getContainer().selector) : document.select(String.format(orderWebRule.getContainer().selector, orderWebRule.getContainer().equation));
        return elements;
    }

    private List<OrderEntity> convertToOrderEntity(List<OrderHtml> orderHtmls, @Nullable OrderDetailWebRuleJson orderDetailWebRule) {
        ArrayList<OrderEntity> orders = new ArrayList<OrderEntity>();
        for (OrderHtml orderHtml : orderHtmls) {
            try {
                OrderEntity order2 = new OrderEntity();
                order2.mId = this.orderWebRule.getMallId();
                order2.title = this.titleFilter(orderHtml.title);
                order2.orderDate = this.orderDateFilter(orderHtml.orderDate);
                order2.orderHms = this.orderHmsFilter(orderHtml.orderHms);
                order2.orderOption = this.orderOptionFilter(orderHtml.orderOption);
                order2.quantity = this.quantityFilter(orderHtml.quantity);
                order2.price = this.priceFilter(orderHtml.price);
                order2.orderNum = this.orderNumFilter(orderHtml.orderNum);
                order2.orderState = this.orderStateFilter(orderHtml.orderState);
                order2.imgUrl = this.imgUrlFilter(orderHtml.imgUrl);
                order2.currency = this.currencyFilter(orderHtml.price);
                order2.detailOrderLink = TextUtils.isEmpty((CharSequence)orderHtml.detailOrderLink) ? this.getDetailOrderLink(order2.orderNum, orderDetailWebRule) : orderHtml.detailOrderLink;
                order2.detailProductLink = orderHtml.detailProdLink;
                Timber.i((String)("filterinfo : " + order2), (Object[])new Object[0]);
                if (!this.isValid(order2)) continue;
                orders.add(order2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return orders;
    }

    private boolean isValid(OrderEntity order2) {
        return !TextUtils.isEmpty((CharSequence)order2.title) && order2.orderDate != null && !TextUtils.isEmpty((CharSequence)order2.orderNum);
    }

    private String getDetailOrderLink(String orderNum, @Nullable OrderDetailWebRuleJson orderDetailWebRule) {
        if (orderDetailWebRule != null) {
            QueryRuleBody urlBody = orderDetailWebRule.getUrl();
            Timber.i((String)("detailUrl" + urlBody + "//" + orderNum), (Object[])new Object[0]);
            if (urlBody != null) {
                StringBuilder detailLink = new StringBuilder();
                detailLink.append(Utils.setOrderNum(orderDetailWebRule.getUrl(), orderNum));
                detailLink.append("\t");
                detailLink.append(Utils.setOrderNum(orderDetailWebRule.getRequestBody(), orderNum));
                detailLink.append("\t");
                detailLink.append(Utils.setOrderNum(orderDetailWebRule.getScripts(), orderNum));
                return detailLink.toString();
            }
        }
        return "";
    }

    private void getOrderPageDocument(String cookie, final OrderWebRule orderWebRule, final OrderCallback<Document> orderCallback) {
        try {
            this.webViewManager.setWebUrl(orderWebRule.getUrl().finalQuery).setScripts(orderWebRule.getPeriodScripts() == null ? null : orderWebRule.getPeriodScripts().finalQuery).setAction(2).build(new WebViewManager.WebViewCallback(){

                @Override
                public void onResult(String html, WebView webView) {
                    Document document = Jsoup.parse((String)html, (String)orderWebRule.getUrl().finalQuery);
                    if (document != null) {
                        orderCallback.onResult(document);
                    }
                }

                @Override
                public void onFail(int statusCode, String statusMessage) {
                    Timber.i((String)("login_webonFail : " + statusCode + "/" + statusMessage), (Object[])new Object[0]);
                    orderCallback.onFail(statusCode, statusMessage);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            orderCallback.onFail(403, "getOrderPageDocument crash");
        }
    }

    protected OrderHtml parseHtml(@NonNull Element element) {
        OrderHtml order2 = new OrderHtml();
        order2.title = this.parseValue(element, this.orderWebRule.getTitle());
        order2.orderDate = this.parseValue(element, this.orderWebRule.getOrderDate());
        order2.orderHms = this.parseValue(element, this.orderWebRule.getOrderHms());
        order2.orderOption = this.parseValue(element, this.orderWebRule.getOrderOption());
        order2.quantity = this.parseValue(element, this.orderWebRule.getQuantity());
        order2.price = this.parseValue(element, this.orderWebRule.getPrice());
        order2.orderNum = this.parseValue(element, this.orderWebRule.getOrderNum());
        order2.orderState = this.parseValue(element, this.orderWebRule.getOrderState());
        order2.imgUrl = this.parseValue(element, this.orderWebRule.getImgUrl());
        order2.detailOrderLink = this.parseValue(element, this.orderWebRule.getDetailOrderLink());
        order2.detailProdLink = this.parseValue(element, this.orderWebRule.getDetailProductLink());
        Timber.i((String)("parseHtmlorder : " + order2), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)order2.title) || TextUtils.isEmpty((CharSequence)order2.orderNum)) {
            return null;
        }
        return order2;
    }

    protected String titleFilter(@NonNull String title) {
        return title;
    }

    protected Date orderDateFilter(@NonNull String orderDate) {
        return TextUtils.isEmpty((CharSequence)orderDate) ? null : DateUtils.transformDate(orderDate, Constants.DateFormatType.DASH);
    }

    protected Date orderHmsFilter(@NonNull String orderHms) {
        return TextUtils.isEmpty((CharSequence)orderHms) ? null : DateUtils.transformHms(orderHms);
    }

    protected String orderOptionFilter(@NonNull String orderOption) {
        return orderOption;
    }

    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        return TextUtils.isEmpty((CharSequence)quantity) ? 1 : Integer.parseInt(quantity);
    }

    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return TextUtils.isEmpty((CharSequence)price) ? 0.0 : Double.parseDouble(price.replace(",", "").replace("\uc6d0", ""));
    }

    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum;
    }

    protected String orderStateFilter(@NonNull String orderState) {
        return orderState;
    }

    protected String imgUrlFilter(@NonNull String imgUrl) {
        return imgUrl;
    }

    protected String currencyFilter(@NonNull String price) {
        return price.contains(".") ? "USD" : "KRW";
    }

    String parseValue(Element element, ParsingOrderRules parsingOrderRules) {
        boolean pos = false;
        if (parsingOrderRules == null) {
            return "";
        }
        String key = parsingOrderRules.selector;
        String attr = parsingOrderRules.attribute;
        String result = "";
        Timber.i((String)("parseValuekey : " + key + "/attr : " + attr), (Object[])new Object[0]);
        try {
            if (!TextUtils.isEmpty((CharSequence)key)) {
                if (key.contains("br")) {
                    key = key.replace("br", "b");
                    int classPos = key.indexOf(".");
                    int classPosEnd = key.indexOf(" ", classPos);
                    String classKey = key.substring(classPos, classPosEnd);
                    Element tempValue = (Element)element.select(classKey).get(0);
                    Document replace = Jsoup.parse((String)tempValue.toString().replace("br", "b"));
                    Timber.i((String)("parseValuereplace : " + replace), (Object[])new Object[0]);
                    element = replace;
                }
                Element value = element.select(key).first();
                Timber.i((String)("parseValuevalue : " + value), (Object[])new Object[0]);
                if (value != null) {
                    result = TextUtils.isEmpty((CharSequence)attr) ? value.text() : (attr.contains("href") ? value.absUrl("href") : value.attr(attr));
                }
                Timber.i((String)("parseValueresult : " + result), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            result = "";
            e.printStackTrace();
        }
        return result;
    }

    public boolean doCheckLoginError() {
        return this.loginWebRule.getFailMessage() != null && !TextUtils.isEmpty((CharSequence)this.loginWebRule.getFailMessage().selector);
    }

    public boolean doCheckLoginCaptcha() {
        return this.loginWebRule.getCaptchaContainer() != null && !TextUtils.isEmpty((CharSequence)this.loginWebRule.getCaptchaContainer().selector);
    }

    public String checkLoginError(Document document) {
        return this.doCheckLoginError() ? this.checkLoginErrorClass(document) : "";
    }

    protected String checkLoginErrorClass(Document document) {
        Timber.i((String)("checkLoginErrorClassfailMessage : " + this.loginWebRule.getFailMessage()), (Object[])new Object[0]);
        Elements elements = document.select(this.loginWebRule.getFailMessage().selector);
        Timber.i((String)("checkLoginelements_size : " + elements.size()), (Object[])new Object[0]);
        if (elements.size() > 0) {
            return elements.first().text();
        }
        return "";
    }

    public boolean checkCaptchaImage(Document document) {
        return this.doCheckLoginCaptcha() && this.checkCaptchaClass(document);
    }

    public boolean checkOTPPage(Document document) {
        return this.checkLoginFormId(document);
    }

    protected boolean checkLoginFormId(Document document) {
        return false;
    }

    protected boolean checkCaptchaClass(Document document) {
        Elements elements = document.select(this.loginWebRule.getCaptchaContainer().selector);
        Timber.i((String)("checkCaptchaClasssize : " + elements.size() + "/container : " + this.loginWebRule.getCaptchaContainer()), (Object[])new Object[0]);
        return elements.size() != 0;
    }

    public boolean identifyLoginPageOrNot(String url) {
        return this.checkLoginPageOrNot(url);
    }

    protected boolean checkLoginPageOrNot(String url) {
        return url.contains("Login") || url.contains("login");
    }

    public boolean doParsingMall() {
        return this.mallData.getKeyName().equalsIgnoreCase(Constants.MALL.Interpark.name());
    }

    public void setWebviewSettings(int action, WebView webView) {
        this.setUserAgentString(action, webView);
    }

    protected void setUserAgentString(int action, WebView webView) {
    }

    public boolean shouldPassFinishedWebPages(String url) {
        return this.passFinishedWebPages(url);
    }

    protected boolean passFinishedWebPages(String url) {
        return false;
    }

    public boolean shouldShowWebView(String url) {
        return this.showWebViewOrNot(url);
    }

    protected boolean showWebViewOrNot(String url) {
        return false;
    }

    public boolean doCheckLoginOTP() {
        return this.doCheckLoginOTPForMall();
    }

    protected boolean doCheckLoginOTPForMall() {
        return false;
    }

    static interface OrderCallback<T> {
        public void onResult(T var1);

        public void onFail(int var1, String var2);
    }
}

