/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.repository;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.api.ScrapApiService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.db.dao.LoginApiRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginWebRuleDao;
import com.tenqube.visual_scraper.db.dao.MallDao;
import com.tenqube.visual_scraper.db.dao.MallWithUserDao;
import com.tenqube.visual_scraper.db.dao.OrderApiRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.OrderDetailWebRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderWebRuleDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.model.api.request.OrderBody;
import com.tenqube.visual_scraper.model.api.request.SaveOrdersBody;
import com.tenqube.visual_scraper.model.api.request.SignUpBody;
import com.tenqube.visual_scraper.model.api.response.LoginWebRuleResponse;
import com.tenqube.visual_scraper.model.api.response.MallResponse;
import com.tenqube.visual_scraper.model.api.response.OrderDetailHtmlResponse;
import com.tenqube.visual_scraper.model.api.response.OrderWebRuleResponse;
import com.tenqube.visual_scraper.model.api.response.ResultBody;
import com.tenqube.visual_scraper.model.api.response.ResultRuleVersion;
import com.tenqube.visual_scraper.model.api.response.ResultSignUp;
import com.tenqube.visual_scraper.model.api.response.RuleResponse;
import com.tenqube.visual_scraper.model.query.LoginRule;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.view.MallInfo;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.model.view.ViewMoreInfo;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.DateUtils;
import com.tenqube.visual_scraper.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;
import timber.log.Timber;

public class ScrapRepository {
    private static ScrapRepository sInstance;
    private Context context;
    private AppExecutors appExecutors;
    private final ScraperDatabase mDatabase;
    private final UserDao userDao;
    private final OrderDao orderDao;
    private final UserWithOrdersDao userWithOrdersDao;
    private final MallWithUserDao mallWithUserDao;
    private final MallDao mallDao;
    private final LoginRuleDao loginRuleDao;
    private final LoginApiRuleDao loginApiRuleDao;
    private final LoginWebRuleDao loginWebRuleDao;
    private final OrderApiRuleDao orderApiRuleDao;
    private final OrderWebRuleDao orderWebRuleDao;
    private final OrderDetailWebRuleDao orderDetailWebRuleDao;
    private final ScrapApiService mApi;
    private SharedPreferences preferences;

    private ScrapRepository(Context context, ScraperDatabase database, ScrapApiService scrapApi, AppExecutors appExecutors, SharedPreferences preferences) {
        this.context = context;
        this.mDatabase = database;
        this.userDao = database.userDao();
        this.orderDao = database.orderDao();
        this.userWithOrdersDao = database.userWithOrdersDao();
        this.mallWithUserDao = database.mallWithUserDao();
        this.mallDao = database.mallDao();
        this.loginRuleDao = database.loginRuleDao();
        this.loginApiRuleDao = database.loginApiRuleDao();
        this.loginWebRuleDao = database.loginWebRuleDao();
        this.orderApiRuleDao = database.orderApiRuleDao();
        this.orderWebRuleDao = database.orderWebRuleDao();
        this.orderDetailWebRuleDao = database.orderDetailWebRuleDao();
        this.preferences = preferences;
        this.mApi = scrapApi;
        this.appExecutors = appExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrapRepository getInstance(Context context, ScraperDatabase database, ScrapApiService scrapApi, AppExecutors appExecutors, SharedPreferences preferences) {
        if (sInstance != null) return sInstance;
        Class<ScrapRepository> clazz = ScrapRepository.class;
        synchronized (ScrapRepository.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ScrapRepository(context, database, scrapApi, appExecutors, preferences);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return sInstance;
        }
    }

    public void saveKey(String apiKey) {
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            apiKey = "sVPnrNW0Fg4fujRSLJrYn8FJWyO5BtS21hAbOYXc";
        }
        this.preferences.edit().putString("x-api-key", apiKey).apply();
    }

    public void saveLayer(String layer) {
        this.preferences.edit().putString("layer", layer).apply();
    }

    public void signUpUser(String appName, String uuid, String adId, ScrapService.Callback<Boolean> callback) {
        this.appExecutors.networkIO().execute(() -> {
            try {
                Response response = this.mApi.callSignUpUser(new SignUpBody(appName, uuid, adId)).execute();
                if (response.isSuccessful()) {
                    Timber.i((String)("signUpUsersuccess : " + response.body()), (Object[])new Object[0]);
                    this.preferences.edit().putString("uuid", uuid).apply();
                    ResultBody result = (ResultBody)response.body();
                    if (result != null) {
                        this.preferences.edit().putString("token", ((ResultSignUp)result.result).authorization.mall).apply();
                        this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(true));
                    }
                } else {
                    Timber.i((String)("signUpUsererror :" + response.message()), (Object[])new Object[0]);
                    this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(false));
                }
            }
            catch (Exception e) {
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(false));
            }
        });
    }

    public void syncRule(@Nullable ScrapService.onResultInterface<Void> callback) {
        this.appExecutors.networkIO().execute(() -> {
            try {
                int clientVersion;
                ResultRuleVersion serverVersion;
                Response versionResponse = this.mApi.callGetRuleVersion().execute();
                if (versionResponse.isSuccessful() && (serverVersion = (ResultRuleVersion)versionResponse.body()) != null && serverVersion.version > (clientVersion = this.preferences.getInt("version", -1))) {
                    this.callRuleAndInsertDB();
                }
                this.appExecutors.mainThread().execute(() -> {
                    if (callback != null) {
                        callback.onDataLoaded(null);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.appExecutors.mainThread().execute(() -> {
                    if (callback != null) {
                        callback.onDataLoaded(null);
                    }
                });
            }
        });
    }

    private void callRuleAndInsertDB() throws Exception {
        ResultBody results;
        Response response = this.mApi.callGetRules().execute();
        if (response.isSuccessful() && (results = (ResultBody)response.body()) != null) {
            if (((RuleResponse)results.result).getMalls() != null) {
                this.insertMalls(((RuleResponse)results.result).getMalls());
            }
            if (((RuleResponse)results.result).getLoginHtmlRules() != null) {
                this.insertLoginWebRules(((RuleResponse)results.result).getLoginHtmlRules());
            }
            if (((RuleResponse)results.result).getOrderHtmlRules() != null) {
                this.insertOrderWebRules(((RuleResponse)results.result).getOrderHtmlRules());
            }
            if (((RuleResponse)results.result).getOrderDetailHtmlRules() != null) {
                this.insertOrderDetailWebRules(((RuleResponse)results.result).getOrderDetailHtmlRules());
            }
            this.preferences.edit().putInt("version", ((RuleResponse)results.result).getVersion()).apply();
        }
    }

    private void insertMalls(List<MallResponse> results) {
        ArrayList<MallEntity> malls = new ArrayList<MallEntity>();
        for (MallResponse res : results) {
            malls.add(res.toEntity());
        }
        this.mallDao.insertList(malls);
    }

    private void insertLoginWebRules(List<LoginWebRuleResponse> results) {
        ArrayList<LoginWebRule> values = new ArrayList<LoginWebRule>();
        for (LoginWebRuleResponse res : results) {
            values.add(res.toEntity());
        }
        List<Long> ids = this.loginWebRuleDao.insertList(values);
        Timber.i((String)("ids" + ids.toString()), (Object[])new Object[0]);
    }

    private void insertOrderWebRules(List<OrderWebRuleResponse> results) {
        ArrayList<OrderWebRule> values = new ArrayList<OrderWebRule>();
        for (OrderWebRuleResponse res : results) {
            values.add(res.toEntity());
        }
        this.orderWebRuleDao.insertList(values);
    }

    private void insertOrderDetailWebRules(List<OrderDetailHtmlResponse> results) {
        ArrayList<OrderDetailWebRuleJson> values = new ArrayList<OrderDetailWebRuleJson>();
        for (OrderDetailHtmlResponse res : results) {
            values.add(res.toEntity());
        }
        this.orderDetailWebRuleDao.insertList(values);
    }

    public void callInsertOrderList() {
        this.appExecutors.networkIO().execute(() -> {
            if (!TextUtils.isEmpty((CharSequence)this.preferences.getString("token", ""))) {
                List<OrderEntity> dataList = this.orderDao.getOrdersForServer();
                Timber.i((String)("callInsertOrderList" + dataList.size()), (Object[])new Object[0]);
                if (dataList.size() > 0) {
                    ArrayList<OrderBody> results = new ArrayList<OrderBody>();
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (OrderEntity o : dataList) {
                        OrderBody orderBody = new OrderBody(o.mId, o.title, DateUtils.transformDateStr(o.orderDate), o.orderHms == null ? "" : DateUtils.transformHmsStr(o.orderHms), o.orderOption, o.quantity, o.price, o.currency, o.orderNum, o.orderState, o.imgUrl, o.detailProductLink);
                        results.add(orderBody);
                        ids.add(o._id);
                        Timber.i((String)("saveOrderBodyinfo : " + orderBody), (Object[])new Object[0]);
                    }
                    try {
                        Timber.i((String)("resultSaveOrdersBody : " + new SaveOrdersBody(results)), (Object[])new Object[0]);
                        Response response = this.mApi.callSaveOrders(new SaveOrdersBody(results)).execute();
                        if (response.isSuccessful()) {
                            String result = (String)response.body();
                            this.orderDao.updateIsSendServer(ids);
                            Timber.i((String)("callInsertOrderListresult : " + result), (Object[])new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void getOrderList(ScrapService.Callback<List<OrderEntity>> callback, int ... mIds) {
        this.appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = this.orderDao.getOrders(mIds);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
        });
    }

    public void getOrderList(ScrapService.Callback<List<OrderEntity>> callback, int mId) {
        this.appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = this.orderDao.getOrders(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
        });
    }

    public void getOrderList(int limit, ViewMoreInfo viewMoreInfo, ScrapService.Callback<List<OrderInfo>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            boolean isMore = viewMoreInfo != null;
            List<OrderEntity> list = isMore ? this.getMoreOrderList(limit, viewMoreInfo) : this.orderDao.getOrderList(limit);
            ArrayList<Integer> mIds = new ArrayList<Integer>();
            for (OrderEntity order : list) {
                mIds.add(order.getmId());
            }
            List<MallEntity> malls = this.mallDao.findMallByIds(mIds);
            SparseArray mallSparseArray = new SparseArray();
            for (MallEntity mallEntity : malls) {
                mallSparseArray.append(mallEntity.getId(), (Object)mallEntity);
            }
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(Utils.convertOrderInfo(list, (SparseArray<MallEntity>)mallSparseArray)));
        });
    }

    private List<OrderEntity> getMoreOrderList(int limit, @NonNull ViewMoreInfo viewMoreInfo) {
        int limitOrderId = viewMoreInfo.getLastOrderId() == 0 ? this.orderDao.getLastOrderId() : viewMoreInfo.getLastOrderId();
        return this.orderDao.getOrdersForViewMore(limit, limitOrderId, viewMoreInfo.getBottomOrderDate(), viewMoreInfo.getBottomOrderId());
    }

    public void isExistUser(int userId, ScrapService.Callback<Boolean> callback) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                UserEntity userEntity = this.userDao.getUser(userId);
                callback.onDataLoaded(userEntity != null);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateUserLastScrapAt(long lastScrapAt, int mallId, String userId) {
        try {
            this.appExecutors.diskIO().execute(() -> this.userDao.updateUserLastScrapAt(lastScrapAt, mallId, userId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateUserForSignOut(final int mId, final ScrapService.OnResultCallback<Void> callback) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                final long i = this.userDao.updateUserIsLogin(mId, false);
                Timber.i((String)("updateUserForSignOuti : " + i), (Object[])new Object[0]);
                this.appExecutors.mainThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (i > 0L) {
                            callback.onDataLoaded(null);
                        } else {
                            callback.onFail(mId, Constants.ERROR.LOGIN_OUT_FAIL, "logout fail");
                        }
                    }
                });
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertOrders(List<OrderEntity> orderEntityList, ScrapService.Callback<List<OrderEntity>> callback) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                List<Long> savedIds = this.orderDao.insertList(orderEntityList);
                Timber.i((String)("insertOrderssavedIds size : " + savedIds.size() + " / " + savedIds), (Object[])new Object[0]);
                ArrayList<Long> resultIds = new ArrayList<Long>();
                for (Long l : savedIds) {
                    if (l == -1L) continue;
                    resultIds.add(l);
                }
                Timber.i((String)("insertOrdersresultIds size : " + resultIds.size() + " / " + resultIds), (Object[])new Object[0]);
                List<OrderEntity> savedList = this.orderDao.getOrderList(resultIds);
                Timber.i((String)("insertOrderssavedList size : " + savedList.size() + " / " + savedList), (Object[])new Object[0]);
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(savedList));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertUsers(UserEntity userEntity, ScrapService.Callback<Integer> callback) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                int uId;
                UserEntity user = this.userDao.getUserByNameAndMal(userEntity.getUserId(), userEntity.getMallId());
                if (user == null) {
                    uId = this.userDao.insert(userEntity).intValue();
                } else {
                    this.userDao.update(userEntity);
                    uId = user.getId();
                }
                Timber.i((String)("INSERT USER uId:" + uId), (Object[])new Object[0]);
                this.appExecutors.mainThread().execute(() -> {
                    if (callback != null) {
                        callback.onDataLoaded(uId);
                    }
                });
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideOrder(int orderId) {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.hideOrder(orderId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOrder(int orderId) {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteOrder(orderId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOrders(int ... orderIds) {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteOrders(orderIds));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOrderByMallIds(int ... mIds) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                int i = this.orderDao.deleteOrderForMallIds(mIds);
                Timber.i((String)"deleted Item size : %s ", (Object[])new Object[]{i});
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAllOrders() {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteAll());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        this.appExecutors.diskIO().execute(() -> {
            this.preferences.edit().clear().apply();
            this.mDatabase.clearAllTables();
        });
    }

    public void checkIsActiveMall(int mId, ScrapService.Callback<MallEntity> callback) {
        Runnable runnable = () -> {
            MallEntity mallEntity = this.mallDao.getMall(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(mallEntity));
        };
        this.appExecutors.diskIO().execute(runnable);
    }

    public void getMallList(ScrapService.Callback<List<MallInfo>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                List<MallEntity> list = this.mallDao.getMalls();
                ArrayList<MallInfo> results = new ArrayList<MallInfo>();
                for (MallEntity mallEntity : list) {
                    results.add(new MallInfo(mallEntity.getId(), mallEntity.getDisplayName(), mallEntity.getIconUrl()));
                }
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getMallWithUser(int mId, String uId, ScrapService.onResultInterface<MallWithUser> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                MallWithUser mallWithUser = this.mallWithUserDao.getInfo(mId, uId);
                this.appExecutors.mainThread().execute(() -> {
                    if (mallWithUser != null) {
                        callback.onDataLoaded(mallWithUser);
                    } else {
                        callback.onFail();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getMallWithUser(ScrapService.Callback<List<MallWithUser>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                List<MallEntity> malls = this.mallDao.getMalls();
                List<UserEntity> users = this.userDao.findUsersByLoginState(1);
                SparseArray userEntitySparseArray = new SparseArray();
                for (UserEntity user : users) {
                    userEntitySparseArray.put(user.getMallId(), (Object)user);
                }
                ArrayList<MallWithUser> list = new ArrayList<MallWithUser>();
                for (MallEntity mall : malls) {
                    list.add(new MallWithUser(mall, (UserEntity)userEntitySparseArray.get(mall.getId())));
                }
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getMallWithActiveUsers(ScrapService.Callback<List<MallWithUser>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                List<MallWithUser> list = this.mallWithUserDao.getInfosForActiveUser();
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(new ArrayList()));
            }
        });
    }

    public void getMallWithActiveUser(int mallId, ScrapService.Callback<MallWithUser> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                MallWithUser mallWithUser = this.mallWithUserDao.getInfoForActiveUser(mallId);
                Log.i((String)"getMallWithActiveUser", (String)("info : " + mallWithUser));
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(mallWithUser));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getLoginRule(int mId, ScrapService.Callback<LoginRule> callback) {
        this.appExecutors.diskIO().execute(() -> {
            LoginWebRule loginWebRule = this.loginWebRuleDao.findById(mId);
            LoginRule loginRule = new LoginRule();
            loginRule.loginWebRule = loginWebRule;
            Log.i((String)"login", (String)("loginRule : " + loginRule));
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(loginRule));
        });
    }

    public void getOrderWebRule(int mId, ScrapService.Callback<OrderWebRule> callback) {
        this.appExecutors.diskIO().execute(() -> {
            OrderWebRule orderWebRuleJson = this.orderWebRuleDao.getInfo(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(orderWebRuleJson));
        });
    }

    public void getOrderApiRule(int mId, ScrapService.Callback<OrderApiRuleJson> callback) {
        this.appExecutors.diskIO().execute(() -> {
            OrderApiRuleJson orderApiRuleJson = this.orderApiRuleDao.getInfo(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(orderApiRuleJson));
        });
    }

    public void getDetailHtmlRule(int mId, ScrapService.Callback<OrderDetailWebRuleJson> callback) {
        this.appExecutors.diskIO().execute(() -> {
            OrderDetailWebRuleJson orderDetailWebRuleJson = this.orderDetailWebRuleDao.getInfo(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(orderDetailWebRuleJson));
        });
    }

    public void getLastOrderId(ScrapService.Callback<Integer> callback) {
        this.appExecutors.diskIO().execute(() -> {
            int lastId = this.orderDao.getLastOrderId();
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(lastId));
        });
    }

    public void deleteUsersByMallId(int mallId) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                this.userDao.deleteUsersByMallId(mallId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

