/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.Date;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class Coupang
extends Mall {
    private static final String URL = "https://my.coupang.com";

    public Coupang(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    protected Document makeDocument(Document document) {
        return Jsoup.parse((String)document.html().replace(" ,=\"\"", ""));
    }

    @Override
    protected String titleFilter(@NonNull String title) {
        return super.titleFilter(title);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.SLASH);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        int index;
        if (!TextUtils.isEmpty((CharSequence)orderNum) && (index = orderNum.lastIndexOf("/")) != -1 && orderNum.length() > index) {
            return orderNum.substring(index + 1);
        }
        return "";
    }

    @Override
    protected String orderStateFilter(@NonNull String orderState) {
        return TextUtils.isEmpty((CharSequence)orderState) ? "" : orderState.replaceAll("\\d+", "").replace("\n", "");
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        int result = 1;
        try {
            String[] temps;
            if (!TextUtils.isEmpty((CharSequence)quantity) && (temps = quantity.split("/")).length > 1) {
                result = Integer.parseInt(temps[1].replace("\uac1c", "").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        String[] temps;
        if (!TextUtils.isEmpty((CharSequence)price) && (temps = price.split("/")).length >= 1) {
            return Double.parseDouble(temps[0].replace(",", "").replace("\uc6d0", "").trim());
        }
        return 0.0;
    }

    @Override
    protected boolean showWebViewOrNot(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && url.contains("https://login.coupang.com/login/pincode/select?pincodeTicketString=");
    }
}

