package com.tenqube.visual_scraper.api;

import com.tenqube.visual_scraper.model.api.request.SaveOrdersBody;
import com.tenqube.visual_scraper.model.api.request.SignUpBody;
import com.tenqube.visual_scraper.model.api.response.ResultBody;
import com.tenqube.visual_scraper.model.api.response.ResultRuleVersion;
import com.tenqube.visual_scraper.model.api.response.ResultSignUp;
import com.tenqube.visual_scraper.model.api.response.RuleResponse;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;

/**
 * Created by tenqube on 2018. 6. 14..
 */

public interface ScrapApiService {

    String BASE_URL = "https://lmfur57mca.execute-api.ap-northeast-2.amazonaws.com/%s/";//dev/";


    @POST("sign-up")
    Call<ResultBody<ResultSignUp>> callSignUpUser(@Body SignUpBody signUpBody);


    @GET("rules/3")
    Call<ResultBody<RuleResponse>> callGetRules();

    @Headers("client-version: 3")
    @POST("orders")
    Call<String> callSaveOrders(@Body SaveOrdersBody orders);


    @GET("rules/version")
    Call<ResultRuleVersion> callGetRuleVersion();

}
