/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.crawler;

import android.content.Context;
import android.webkit.WebView;
import com.tenqube.visual_scraper.crawler.CrawlerCallback;
import com.tenqube.visual_scraper.crawler.manager.WebManager;
import com.tenqube.visual_scraper.crawler.model.CrawlerRequestData;
import com.tenqube.visual_scraper.crawler.model.CrawlerUrl;

public class Crawler
implements WebManager.OnWebInteractionListener {
    final WebManager webManager;
    final Context context;
    final CrawlerRequestData requestData;
    final CrawlerCallback crawlerCallback;
    CrawlerUrl mUrl;

    Crawler(Context context, CrawlerRequestData requestData, CrawlerCallback crawlerCallback) {
        this.context = context;
        this.requestData = requestData;
        this.crawlerCallback = crawlerCallback;
        this.webManager = new WebManager(context, this);
    }

    public void start() {
        this.loadUrl(this.getCrawlerUrl().getUrl());
    }

    void loadUrl(String url) {
        this.webManager.loadUrl(url);
    }

    public CrawlerUrl getCrawlerUrl() {
        this.mUrl = this.requestData.getUrls().poll();
        return this.mUrl;
    }

    @Override
    public int getTimeOut() {
        return this.requestData.getTimeOut();
    }

    @Override
    public void onTimeOut() {
        this.crawlerCallback.onFail("time out");
    }

    @Override
    public void showHtml(String html) {
        this.crawlerCallback.onComplete(html);
    }

    @Override
    public void checkHtml(String html) {
    }

    @Override
    public void onReceivedError(String msg) {
        this.crawlerCallback.onFail(msg);
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        CrawlerUrl crawlerUrl = this.getCrawlerUrl();
        if (crawlerUrl == null) {
            this.loadUrl("javascript:window.HtmlViewer.showHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
        } else {
            this.loadUrl(crawlerUrl.getUrl());
        }
    }
}

