package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.gson.Gson;
import com.tenqube.visual_scraper.api.HeaderInterceptor;
import com.tenqube.visual_scraper.api.ScrapApiService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.manager.AES256Cipher;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.NullOnEmptyConverterFactory;

import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Injection {

    public static ScrapRepository provideScrapRepository(Context context, SharedPreferences preferences){
        AppExecutors appExecutors = provideAppExecutor();
//        SharedPreferences preferences = provideSharedPreference(context);
        OkHttpClient okHttpClient = provideOkHttpClient(preferences);
        Retrofit retrofit = provideRetrofit(okHttpClient, preferences);
        ScrapApiService apiService = provideScrapApiService(retrofit);

        return ScrapRepository.getInstance(provideScraperDatabase(context, appExecutors), apiService, appExecutors, preferences);
    }

    public static AES256Cipher provideAES256Cipher(Context context) {
        return AES256Cipher.getInstance(context);
    }

    private static AppExecutors provideAppExecutor() {
        return new AppExecutors();
    }

    private static ScraperDatabase provideScraperDatabase(Context context, AppExecutors appExecutors) {
        return ScraperDatabase.getInstance(context, appExecutors);
    }

    public static SharedPreferences provideSharedPreference(Context context) {
        return context.getSharedPreferences("com.tenqube.visual_scraper", Context.MODE_PRIVATE);
    }

    private static ScrapApiService provideScrapApiService(Retrofit retrofit) {
        return retrofit.create(ScrapApiService.class);
    }

    private static Retrofit provideRetrofit(OkHttpClient okHttpClient, SharedPreferences preferences) {

        return new Retrofit.Builder()
                .baseUrl(String.format(ScrapApiService.BASE_URL, preferences.getString(Constants.PREF_KEY.LAYER, "dev")))
                .client(okHttpClient)
                .addConverterFactory(new NullOnEmptyConverterFactory())
                .addConverterFactory(GsonConverterFactory.create(new Gson()))
                .build();
    }

    private static OkHttpClient provideOkHttpClient(SharedPreferences sharedPreferences) {
        HttpLoggingInterceptor logInter = new HttpLoggingInterceptor();
        logInter.setLevel(HttpLoggingInterceptor.Level.BODY);

        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.connectTimeout(15, TimeUnit.SECONDS);
        okHttpClientBuilder.readTimeout(15, TimeUnit.SECONDS);
        okHttpClientBuilder.writeTimeout(15, TimeUnit.SECONDS);

        if(Constants.LAYER.DEV.equals(sharedPreferences.getString(Constants.PREF_KEY.LAYER, "dev")))
            okHttpClientBuilder.addInterceptor(logInter);
        okHttpClientBuilder.addInterceptor(new HeaderInterceptor(sharedPreferences));

        return okHttpClientBuilder.build();
    }
}
