package com.tenqube.visual_scraper.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import java.util.Date;

public class Gshome extends Mall {

    public Gshome(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 1, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderNum(), 0, "data-ord-no");
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, "src");
//        order.detailProdLink = parseValue(element, orderWebRule.getDetailProductLink(), 0, null);
//
//        return order;
//    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.DOT);
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        if (!TextUtils.isEmpty(imgUrl) && !imgUrl.equals("http")) {
            imgUrl = "http:"+imgUrl;
        }
        return imgUrl;
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            return Integer.parseInt(quantity.replace("개", ""));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 1;

    }
    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        try {
            return Double.parseDouble(price
                    .replace(",", "")
                    .replace("원", ""));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}
