/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES256Cipher {
    private static AES256Cipher mInstance;
    private String secretKey;
    private String IV = "";
    private SharedPreferences pref;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AES256Cipher getInstance(Context context) {
        Class<AES256Cipher> clazz = AES256Cipher.class;
        synchronized (AES256Cipher.class) {
            if (mInstance == null) {
                mInstance = new AES256Cipher(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private AES256Cipher(Context context) {
        this.pref = Injection.provideSharedPreference(context);
    }

    private void setKey() {
        String secretKey = this.pref.getString("SECRET_KEY", "");
        if (TextUtils.isEmpty((CharSequence)secretKey)) {
            secretKey = UUID.randomUUID().toString().substring(0, 16);
            this.pref.edit().putString("SECRET_KEY", secretKey).apply();
        }
        this.IV = secretKey.substring(0, 16);
    }

    public String encrypt(String str) {
        this.setKey();
        String enStr = "";
        try {
            byte[] keyData = this.secretKey.getBytes();
            SecretKeySpec secureKey = new SecretKeySpec(keyData, "AES");
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            c.init(1, (Key)secureKey, new IvParameterSpec(this.IV.getBytes()));
            byte[] encrypted = c.doFinal(str.getBytes("UTF-8"));
            enStr = Base64.encodeToString((byte[])encrypted, (int)0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enStr;
    }

    public String decrypt(String str) {
        this.setKey();
        String result = "";
        try {
            byte[] keyData = this.secretKey.getBytes();
            SecretKeySpec secureKey = new SecretKeySpec(keyData, "AES");
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            c.init(2, (Key)secureKey, new IvParameterSpec(this.IV.getBytes("UTF-8")));
            byte[] byteStr = Base64.decode((byte[])str.getBytes(), (int)0);
            result = new String(c.doFinal(byteStr), "UTF-8");
        }
        catch (Exception e) {
            LogUtil.LOGI("AES", "e" + e.toString());
            e.printStackTrace();
        }
        return result;
    }

    public static String SHA256(String str) {
        String SHA = "";
        try {
            MessageDigest sh = MessageDigest.getInstance("SHA-256");
            sh.update(str.getBytes());
            byte[] byteData = sh.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            SHA = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            SHA = null;
        }
        return SHA;
    }
}

