package com.tenqube.visual_scraper.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;

import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.constants.Constants;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;


public class AES256Cipher {

    private static AES256Cipher mInstance;
    private String secretKey;
    private String IV = ""; //16bit
    private SharedPreferences pref;


    public static AES256Cipher getInstance(Context context){

        synchronized (AES256Cipher.class) {
            if(mInstance == null){
                mInstance = new AES256Cipher(context);
            }
        }
        return mInstance;

    }

    private AES256Cipher(Context context) {
        this.pref = Injection.provideSharedPreference(context);
    }

    private void setKey() {
        String secretKey = pref.getString(Constants.PREF_KEY.SECRET_KEY, "");

        if(TextUtils.isEmpty(secretKey)) {
            secretKey = UUID.randomUUID().toString().substring(0, 16);
            pref.edit().putString(Constants.PREF_KEY.SECRET_KEY, secretKey).apply();
        }
        IV = secretKey.substring(0, 16);
    }

    //암호화
    public String encrypt(String str) {
        setKey();
        String enStr="";
        try {
            byte[] keyData = secretKey.getBytes();

            SecretKey secureKey = new SecretKeySpec(keyData, "AES");

            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            c.init(Cipher.ENCRYPT_MODE, secureKey, new IvParameterSpec(IV.getBytes()));

            byte[] encrypted = c.doFinal(str.getBytes("UTF-8"));
            enStr = Base64.encodeToString(encrypted, Base64.DEFAULT);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return enStr;
    }

    //복호화
    public String decrypt(String str) {
        setKey();

        String result="";
        try{
            byte[] keyData = secretKey.getBytes();
            SecretKey secureKey = new SecretKeySpec(keyData, "AES");
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            c.init(Cipher.DECRYPT_MODE, secureKey, new IvParameterSpec(IV.getBytes("UTF-8")));

            byte[] byteStr = Base64.decode(str.getBytes(), Base64.DEFAULT);

            result= new String(c.doFinal(byteStr),"UTF-8");
        } catch (Exception e){
            LOGI("AES", "e" + e.toString());
            e.printStackTrace();
        }

        return result;

    }


    public static String SHA256(String str){
        String SHA = "";
        try{
            MessageDigest sh = MessageDigest.getInstance("SHA-256");
            sh.update(str.getBytes());
            byte byteData[] = sh.digest();
            StringBuffer sb = new StringBuffer();
            for(int i = 0 ; i < byteData.length ; i++){
                sb.append(Integer.toString((byteData[i]&0xff) + 0x100, 16).substring(1));
            }
            SHA = sb.toString();

        }catch(NoSuchAlgorithmException e){
            e.printStackTrace();
            SHA = null;
        }
        return SHA;
    }



}