package com.tenqube.visual_scraper.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.SparseArray;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;

import com.google.gson.Gson;
import com.tenqube.visual_scraper.R;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.model.jsonParsing.ValueRules;
import com.tenqube.visual_scraper.model.view.OrderInfo;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

import timber.log.Timber;


public class Utils {

    @SuppressWarnings("deprecation")
    public static void clearCookies(Context context)
    {

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            CookieManager.getInstance().removeAllCookies(null);
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager cookieSyncMngr=CookieSyncManager.createInstance(context);
            cookieSyncMngr.startSync();
            CookieManager cookieManager=CookieManager.getInstance();
            cookieManager.removeAllCookie();
            cookieManager.removeSessionCookie();
            cookieSyncMngr.stopSync();
            cookieSyncMngr.sync();
        }
    }

    public static boolean hasPermissions(@NonNull Context context, @NonNull String... perms) {
        // Always return true for SDK < M, let the system deal with the permissions
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            // DANGER ZONE!!! Changing this will break the library.
            return true;
        }

        for (String perm : perms) {
            boolean hasPerm = (ContextCompat.checkSelfPermission(context, perm) ==
                    PackageManager.PERMISSION_GRANTED);
            if (!hasPerm) {
                return false;
            }
        }

        return true;
    }

//    public static String getDeviceId(Context context) {
//        try {
//
//            AdvertisingIdClient.Info info = getAdvertisingIdInfo(context);
//            if(info != null && !info.isLimitAdTrackingEnabled()) {
//                return info.getId();
//            } else {
//                return getAndroidId(context);
//            }
//
//        } catch (Exception e) {
//            return getAndroidId(context);
//        }
//
//    }

    private static String getAndroidId(Context context) {
        try {

            @SuppressLint("HardwareIds")
            String androidDeviceId = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
            return androidDeviceId;

        } catch (Exception e) {
            return "";
        }
    }

    public static void getFinalLoginWebRule(LoginWebRule loginWebRule, String userId, String password) {

        QueryRuleBody urlBody = loginWebRule.getUrl();
        QueryRuleBody scriptsBody = loginWebRule.getLoginScripts();

        List<Object> param;

        // url
        if (urlBody.values == null) {
            loginWebRule.getUrl().finalQuery = urlBody.query;
        } else {
            param = Utils.getLoginParam(urlBody, userId, password);
            Timber.i("getFinalLoginWebRule"+"param : "+param + "/"+urlBody.query);
            String finalStr = String.format(urlBody.query, param.toArray());
            Timber.i("login"+"webview : "+finalStr);
            loginWebRule.getUrl().finalQuery = finalStr;
        }

        // loginScripts
        if (scriptsBody.values == null) {
            loginWebRule.getLoginScripts().finalQuery = scriptsBody.query;
        } else {
            param = Utils.getLoginParam(scriptsBody, userId, password);
            Timber.i("getFinalLoginWebRule"+"param : "+param + "/"+scriptsBody.query);

            String finalStr = String.format(scriptsBody.query, param.toArray());
            Timber.i("getFinalLoginWebRule"+"webview : "+finalStr);
            loginWebRule.getLoginScripts().finalQuery = finalStr;
        }

        Timber.i("final"+"loginWebRule : "+loginWebRule);

    }

    public static List<Object> getLoginParam(QueryRuleBody queryRuleBody, String userId, String password) {
        List<Object> strArray = new ArrayList<>();

        if (queryRuleBody.values != null) {
            for(ValueRules v : queryRuleBody.values) {
                if (v.rule.equals("id")) {
                    strArray.add(userId);
                } else if(v.rule.equals("pw")) {
                    strArray.add(password);
                }
            }
        }
        return strArray;
    }

    public static String getOrderValue (QueryRuleBody queryRuleBody, long lastScrapAt) {
        return queryRuleBody.values != null ?String.format(queryRuleBody.query, getOrderParam(queryRuleBody, lastScrapAt).toArray()) : queryRuleBody.query;
    }


    public static String getFinalDetailUrl(QueryRuleBody queryRuleBody, String orderNum){
        // final query
//        List<Object> strArray = new ArrayList<>();
//        if (queryRuleBody.values != null) {
//            for (ValueRules v : queryRuleBody.values) {
//                if (v.rule.equals("orderNum")) {
//                    strArray.add(strArray);
//                }
//            }
//        }
        queryRuleBody.finalQuery = String.format(queryRuleBody.query, orderNum);
        return queryRuleBody.finalQuery;
    }


    public static ArrayList<Object> getOrderParam(QueryRuleBody queryRuleBody, long lastScrapAt) {
        ArrayList<Object> param = new ArrayList<>();

        for (ValueRules v : queryRuleBody.values) {

            if (v.rule.equals("date")) {
                String s = DateUtils.getDateFormat(v.format, v.range, lastScrapAt);
                Timber.i("date"+ "s : "+ s);
                param.add(s);

            } else if (v.rule.equals("choice")) {
                String[] s= v.option.split("/");
                Timber.i("choice"+ "s : "+ s[0]);
                param.add(s[0]);
            }
        }

        return param;
    }

    public static long getLastScrapAt() {
        return new Date().getTime(); //DateUtils.getDateFormat(DateUtils.LAST_SCRAPT_AT_FORMAT, "0M", 0);
    }


    public static <T> T parseJsonObject(String input, Class<T> tClass) {
        try {
            return TextUtils.isEmpty(input) ? null : Utils.fromJson(input, tClass);
        } catch (Exception e) {
            return null;
        }

    }

    private static  <T> T fromJson(String param, Class<T> classOfT) throws Exception {
        Gson gson = new Gson();
        return gson.fromJson(param, classOfT);
    }

    public static String toJson(Object object) {

        Gson gson = new Gson();
        return gson.toJson(object);
    }

    public static String loadJSONFromAsset(@NonNull Context context, String fileName) {
        String json = null;
        try {
            AssetManager am = context.getAssets();
            InputStream is = am.open(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");
        } catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return json;
    }

    public static int calculateEquation(String equation) {
        int result = 0;
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("rhino");

            result = new BigDecimal(engine.eval(equation).toString()).intValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Timber.i("calculateEquation" +"result :" + result);
        return result;
    }

    public static List<OrderInfo> convertOrderInfo(@NonNull List<OrderEntity> list,
                                                   @NonNull SparseArray<MallEntity> mallEntitySparseArray) {
        List<OrderInfo> results = new ArrayList<>();

        for (OrderEntity orderEntity : list) {

            if(mallEntitySparseArray.get(orderEntity.getmId()) != null) {
                String iconUrl = mallEntitySparseArray.get(orderEntity.getmId()).getIconUrl();
                int iconResId = getMallResId(mallEntitySparseArray.get(orderEntity.getmId()).getName());

                results.add(new OrderInfo(orderEntity._id,orderEntity.mId,orderEntity.uId,orderEntity.title,
                                orderEntity.orderDate,orderEntity.orderHms,orderEntity.orderOption,orderEntity.quantity,
                                orderEntity.price,orderEntity.currency,orderEntity.orderNum,orderEntity.orderState,
                                orderEntity.imgUrl,orderEntity.detailOrderLink,orderEntity.detailProductLink,
                                iconResId, iconUrl));

            }

        }

        return results;
    }

    public static int getMallResId(String name) {
        switch (name) {

            case Constants.DEFAULT_MALL.Auction:
                return R.drawable.logo_auction;

            case Constants.DEFAULT_MALL.Coupang:
                return R.drawable.logo_coupang;

            case Constants.DEFAULT_MALL.ElevenStreet:
                return R.drawable.logo_11st;

            case Constants.DEFAULT_MALL.Gmarket:
                return R.drawable.logo_gmarket;

            case Constants.DEFAULT_MALL.Gshome:
                return R.drawable.logo_gsshop;

            case Constants.DEFAULT_MALL.Hmall:
                return R.drawable.logo_hmall;

            case Constants.DEFAULT_MALL.Interpark:
                return R.drawable.logo_interpark;

            case Constants.DEFAULT_MALL.LotteHome:
                return R.drawable.logo_lotte;

            case Constants.DEFAULT_MALL.NaverPay:
                return R.drawable.logo_naver;

            case Constants.DEFAULT_MALL.Tmon:
                return R.drawable.logo_tmon;

            case Constants.DEFAULT_MALL.Wemake:
                return R.drawable.logo_wemakeprice;

            case Constants.DEFAULT_MALL.Amazon:
                return R.drawable.logo_amazon;

            default:
                return 0;

        }
    }

}
