/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import android.webkit.WebView;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.ParameterException;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.query.Password;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.model.view.ViewMoreInfo;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.FactoryMall;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import com.tenqube.visual_scraper.scrap.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.List;
import java.util.Locale;
import timber.log.Timber;

public class ScrapServiceImpl
implements ScrapService {
    public Context context;
    private final String apiKey;
    private final String qualifier;
    ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager mWebViewManager;
    private String uuid;
    private String serviceAppName;
    private MallViewService mallViewService;
    public static Locale locale;
    public SparseBooleanArray progressStateArray = new SparseBooleanArray();

    public ScrapServiceImpl(@NonNull Context context, @NonNull MallViewService mallViewService, @NonNull String apiKey, @NonNull String qualifier, @NonNull String uuid, @NonNull String serviceAppName) throws ParameterException {
        this.context = context;
        this.apiKey = apiKey;
        this.qualifier = qualifier;
        this.initLocale();
        this.preferences = Injection.provideSharedPreference(context);
        this.preferences.edit().putString("layer", qualifier).apply();
        this.repository = Injection.provideScrapRepository(context.getApplicationContext(), this.preferences);
        this.repository.saveKey(apiKey);
        this.mallViewService = mallViewService;
        this.uuid = uuid;
        this.serviceAppName = serviceAppName;
        if (qualifier.equals("dev")) {
            Timber.plant((Timber.Tree)new Timber.DebugTree());
        }
    }

    private void initLocale() {
        locale = Build.VERSION.SDK_INT >= 24 ? this.context.getResources().getConfiguration().getLocales().get(0) : this.context.getResources().getConfiguration().locale;
    }

    @Override
    public void initialize() {
        this.repository.initialize();
    }

    @Override
    public WebView getWebView() {
        return this.mWebViewManager.getWebView();
    }

    @Override
    public void startLoginAndParsing(String userId, String userPwd, int mId, ScrapService.OnResultCallback<Void> onResult) throws ParameterException {
        Timber.i((String)("startLoginAndParsing = " + userId + "/" + mId + "/" + userPwd), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)userPwd) || mId == 0) {
            throw new ParameterException("empty parameter");
        }
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, isSuccess -> {
                if (isSuccess.booleanValue()) {
                    this.repository.signUpUser(this.serviceAppName, this.uuid, Void2 -> this.logInAndParsing(userId, userPwd, mId, onResult));
                } else {
                    onResult.onFail(mId, Constants.ERROR.LOGIN_FAIL, "sign up error");
                }
            });
        } else {
            this.logInAndParsing(userId, userPwd, mId, onResult);
        }
    }

    private void logInAndParsing(String userId, String userPwd, int mId, final ScrapService.OnResultCallback<Void> onResult) {
        this.repository.syncRule(callback -> {
            Timber.i((String)"logInAndParsing = syncRule success", (Object[])new Object[0]);
            new Thread(() -> {
                this.progressStateArray.put(mId, true);
                this.start(userId, userPwd, mId, new ScrapService.OnResult<List<OrderEntity>>(){

                    @Override
                    public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                        ScrapServiceImpl.this.progressStateArray.put(mId, false);
                        ScrapServiceImpl.this.repository.getOrderList(items -> onResult.onDataLoaded(null), mId);
                    }

                    @Override
                    public void onFail(int mId, Constants.ERROR error, String msg) {
                        ScrapServiceImpl.this.progressStateArray.put(mId, false);
                        Timber.i((String)("logInAndParsingerror" + error.name() + "onFail" + msg), (Object[])new Object[0]);
                        onResult.onFail(mId, error, msg);
                    }
                });
            }).start();
        });
    }

    public void start(final String userId, final String userPwd, final int mId, final ScrapService.OnResult callback) {
        this.repository.checkIsActiveMall(mId, mall -> {
            if (mall == null) {
                return;
            }
            this.repository.getMallWithUser(mId, userId, new ScrapService.onResultInterface<MallWithUser>(){

                @Override
                public void onDataLoaded(MallWithUser item) {
                    Timber.i((String)"item : %s", (Object[])new Object[]{item});
                    ScrapServiceImpl.this.login(new MallWithUser(item.mall, new UserEntity(mId, userId, new Password(userPwd))), 2, callback);
                }

                @Override
                public void onFail() {
                    Timber.i((String)"mId : %s", (Object[])new Object[]{mId});
                    ScrapServiceImpl.this.login(new MallWithUser(mall, new UserEntity(mId, userId, new Password(userPwd))), 1, callback);
                }
            });
        });
    }

    private void login(MallWithUser mallWithUser, int crud, ScrapService.OnResult onResult) {
        Timber.i((String)("loginMallWithUser : " + mallWithUser), (Object[])new Object[0]);
        this.repository.getLoginRule(mallWithUser.mall.getId(), loginRule -> {
            WebViewManager webViewManager;
            Timber.i((String)("loginloginRule : " + loginRule), (Object[])new Object[0]);
            this.mWebViewManager = webViewManager = new WebViewManager(this.context, this.mallViewService);
            Mall m = FactoryMall.create(new MallData(mallWithUser.mall.getId(), mallWithUser.mall.getName(), mallWithUser.mall.getDisplayName()), this.repository, webViewManager);
            Timber.i((String)("loginMall : " + m), (Object[])new Object[0]);
            if (m == null) {
                return;
            }
            webViewManager.setMall(m);
            if (loginRule != null && loginRule.loginWebRule != null) {
                Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc874\uc7ac, startWebViewLogin", (Object[])new Object[0]);
                m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, crud, onResult);
            } else {
                Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c ", (Object[])new Object[0]);
                onResult.onFail(mallWithUser.mall.getId(), Constants.ERROR.NOT_FOUND_LOGIN_RULE, mallWithUser.mall.getDisplayName() + " login rule does not exist");
            }
        });
    }

    @Override
    public void startParsingMalls(ScrapService.OnResultCallback<Void> onResult) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, isSuccess -> {
                if (isSuccess.booleanValue()) {
                    this.getMallsAndParsing(onResult);
                } else {
                    onResult.onDataLoaded(null);
                }
            });
        } else {
            this.repository.syncRule(callback -> this.getMallsAndParsing(onResult));
        }
    }

    private void getMallsAndParsing(final ScrapService.OnResultCallback<Void> onResult) {
        if (DateUtils.checkDiffTime(this.preferences.getLong("CHECK_PARSING_TIME", 0L), this.preferences.getInt("PARSING_FREQUENCY", 10))) {
            Timber.i((String)"parsingcheckDiffTime true", (Object[])new Object[0]);
            this.preferences.edit().putLong("CHECK_PARSING_TIME", System.currentTimeMillis()).apply();
            this.repository.getMallWithActiveUsers(items -> {
                Timber.i((String)("getMallsAndParsingitem : " + items), (Object[])new Object[0]);
                for (MallWithUser mallWithUser : items) {
                    Timber.i((String)("getMallsAndParsingmallWithUser : " + mallWithUser), (Object[])new Object[0]);
                    new Thread(() -> this.login(mallWithUser, 0, new ScrapService.OnResult<List<OrderEntity>>(){

                        @Override
                        public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                            Timber.i((String)("onSuccessmId : " + mId + "Update size : " + itemList), (Object[])new Object[0]);
                            onResult.onDataLoaded(null);
                        }

                        @Override
                        public void onFail(int mId, Constants.ERROR error, String msg) {
                            Timber.i((String)("onFailmId : " + mId + "update error : " + (Object)((Object)error) + msg), (Object[])new Object[0]);
                        }
                    })).start();
                }
            });
        } else {
            Timber.i((String)"getMallsAndParsingrequest later", (Object[])new Object[0]);
            onResult.onFail(-1, Constants.ERROR.REQUEST_FREQUENT, "request later");
        }
    }

    @Override
    public void startParsingMall(int mallId, ScrapService.OnResultCallback<Void> onResult) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, isSuccess -> {
                if (isSuccess.booleanValue()) {
                    this.getInfoAndMallParsing(mallId, onResult);
                } else {
                    onResult.onFail(mallId, Constants.ERROR.LOGIN_FAIL, "need sign up");
                }
            });
        } else {
            this.getInfoAndMallParsing(mallId, onResult);
        }
    }

    private void getInfoAndMallParsing(int mallId, final ScrapService.OnResultCallback<Void> onResult) {
        this.repository.getMallWithActiveUser(mallId, mallWithUser -> this.login((MallWithUser)mallWithUser, 0, new ScrapService.OnResult<List<OrderEntity>>(){

            @Override
            public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                Timber.i((String)("onSuccessmId : " + mId + "Update size : " + itemList), (Object[])new Object[0]);
                onResult.onDataLoaded(null);
            }

            @Override
            public void onFail(int mId, Constants.ERROR error, String msg) {
                Timber.i((String)("onFailmId : " + mId + "update error : " + (Object)((Object)error) + msg), (Object[])new Object[0]);
            }
        }));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.preferences.edit().putBoolean("SDK_IS_ENABLE", enabled).apply();
    }

    private boolean isEnabledSDK() {
        return this.preferences.getBoolean("SDK_IS_ENABLE", false);
    }

    @Override
    public void getOrderList(int limit, ViewMoreInfo viewMoreInfo, ScrapService.OnResultCallback<List<OrderInfo>> callback) {
        this.repository.getOrderList(limit, viewMoreInfo, callback::onDataLoaded);
    }

    @Override
    public void getMallWithUsers(ScrapService.Callback<List<MallWithUser>> callback) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, isSuccess -> {
                if (isSuccess.booleanValue()) {
                    this.getMalls(callback);
                } else {
                    callback.onDataLoaded(null);
                }
            });
        } else {
            this.getMalls(callback);
        }
    }

    private void getMalls(ScrapService.Callback<List<MallWithUser>> callback) {
        this.repository.syncRule(mCallback -> this.repository.getMallWithUser(items -> {
            for (MallWithUser mallWithUser : items) {
                mallWithUser.setProgress(this.progressStateArray.get(mallWithUser.mall.getId()));
            }
            callback.onDataLoaded((List<MallWithUser>)items);
        }));
    }

    @Override
    public void signOut(int mId, ScrapService.OnResultCallback<Void> callback) {
        this.repository.updateUserForSignOut(mId, callback);
    }

    @Override
    public void hideOrder(int orderId) {
        this.repository.hideOrder(orderId);
    }

    @Override
    public void deleteOrder(int orderId) {
        this.repository.deleteOrder(orderId);
    }

    @Override
    public void deleteOrders(int ... orderIds) {
        this.repository.deleteOrder(orderIds);
    }

    @Override
    public void deleteAll(int ... mIds) {
        if (mIds != null) {
            this.repository.deleteForMallIds(new int[0]);
        } else {
            this.repository.deleteAll();
        }
    }

    @Override
    public void deleteForMallId(int mid) {
        this.repository.deleteForMallId(mid);
    }

    @Override
    public void insertUserEntity(UserEntity userEntity) {
        this.repository.insertUsers(userEntity);
    }

    @Override
    public void setParsingFrequency(int frequency) {
        this.preferences.edit().putInt("PARSING_FREQUENCY", frequency).apply();
    }

    @Override
    public void setMallViewService(MallViewService mallViewService) {
        if (this.mWebViewManager != null) {
            this.mWebViewManager.setViewService(mallViewService);
        }
    }

    @Override
    public void getLastOrderId(ScrapService.Callback<Integer> callback) {
        this.repository.getLastOrderId(callback);
    }
}

