package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.data.MallData;
import com.tenqube.visual_scraper.utils.Utils;

import org.w3c.dom.Text;

import java.text.ParseException;
import java.util.Date;

import static com.tenqube.visual_scraper.utils.DateUtils.AMAZON_DATE_FORMAT;

public class Amazon extends Mall{

    public Amazon(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }


    // https://www.amazon.com/gp/your-account/order-details/ref=ppx_yo_dt_b_order_details_o00_s00?ie=UTF8&orderID=113-6284413-2924239
    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        String result = "";
        int pos = orderNum.lastIndexOf("oid=");

        if (pos > -1 && orderNum.length() > pos) {
            result = orderNum.substring(pos+4, orderNum.length());
        }
        Log.i("orderNumFilter","result : "+result);
        return result;
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        if (TextUtils.isEmpty(orderDate) || orderDate.contains("Arriving") || orderDate.contains("도착")) {
            return new Date();
        } else {
            orderDate = orderDate.replace("Ordered on","").trim();
            try {
                return AMAZON_DATE_FORMAT.parse(orderDate);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return new Date();
    }

//    @Override
////    protected double priceFilter(@NonNull String price) throws NumberFormatException {
////        return Double.parseDouble(price.replace("$",""));
////    }


    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return 0.0;//Double.NaN;
    }

    @Override
    protected String currencyFilter(@NonNull String price) {
        return "USD";
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        if (url.contains("www.amazon.com/ap/signin")) {
            // fail case
            return true;

        } else if(!url.contains("https://www.amazon.com/?ref_=nav_signin&captcha_verified=1&") || url.contains("https://www.amazon.com/?ref_=nav_signin&")){
            // success case
            return false;
        }

        return false;
    }

    @Override
    protected void setUserAgentString(int action, WebView webView) {
        if (action == WebViewManager.ORDER_PARSING) {
            webView.getSettings().setUserAgentString(null);
        } else {
            webView.getSettings().setUserAgentString(Constants.USER_AGENT_NORMAL);
        }

    }
}
