/*
 * Copyright 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

@Entity(tableName = "rules")
public final class RuleEntity {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private final int _id;

    @ColumnInfo(name = "name")
    private final String name;

    @NonNull
    @ColumnInfo(name = "container")
    private final String container;

    @NonNull
    @ColumnInfo(name = "title")
    private final String title;

    @ColumnInfo(name = "order_date")
    private final String orderDate;

    @ColumnInfo(name = "order_hms")
    private final String orderHms;

    @ColumnInfo(name = "order_option")
    private final String orderOption;

    @ColumnInfo(name = "quantity")
    private final String quantity;

    @ColumnInfo(name = "price")
    private final String price;

    @ColumnInfo(name = "order_num")
    private final String orderNum;

    @ColumnInfo(name = "order_state")
    private final String orderState;

    @ColumnInfo(name = "img_url")
    private final String imgUrl;

    @ColumnInfo(name = "detail_order_link")
    private final String detailOrderLink;

    @ColumnInfo(name = "detail_product_link")
    private final String detailProductLink;

    public RuleEntity(int _id, String name, @NonNull String container, @NonNull String title, String orderDate, String orderHms, String orderOption, String quantity, String price, String orderNum, String orderState, String imgUrl, String detailOrderLink, String detailProductLink) {
        this._id = _id;
        this.name = name;
        this.container = container;
        this.title = title;
        this.orderDate = orderDate;
        this.orderHms = orderHms;
        this.orderOption = orderOption;
        this.quantity = quantity;
        this.price = price;
        this.orderNum = orderNum;
        this.orderState = orderState;
        this.imgUrl = imgUrl;
        this.detailOrderLink = detailOrderLink;
        this.detailProductLink = detailProductLink;
    }

    public int getId() {
        return _id;
    }

    public String getName() {
        return name;
    }

    @NonNull
    public String getContainer() {
        return container;
    }

    @NonNull
    public String getTitle() {
        return title;
    }

    public String getOrderDate() {
        return orderDate;
    }

    public String getOrderHms() {
        return orderHms;
    }

    public String getOrderOption() {
        return orderOption;
    }

    public String getQuantity() {
        return quantity;
    }

    public String getPrice() {
        return price;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public String getOrderState() {
        return orderState;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public String getDetailOrderLink() {
        return detailOrderLink;
    }

    public String getDetailProductLink() {
        return detailProductLink;
    }

    @Override
    public String toString() {
        return "RuleEntity{" +
                "_id=" + _id +
                ", name='" + name + '\'' +
                ", container='" + container + '\'' +
                ", title='" + title + '\'' +
                ", orderDate='" + orderDate + '\'' +
                ", orderHms='" + orderHms + '\'' +
                ", orderOption='" + orderOption + '\'' +
                ", quantity='" + quantity + '\'' +
                ", price='" + price + '\'' +
                ", orderNum='" + orderNum + '\'' +
                ", orderState='" + orderState + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", detailOrderLink='" + detailOrderLink + '\'' +
                ", detailProductLink='" + detailProductLink + '\'' +
                '}';
    }
}
