/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.api;

import android.content.SharedPreferences;
import android.util.Log;
import java.io.IOException;
import java.net.URISyntaxException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderInterceptor
implements Interceptor {
    private final SharedPreferences preferences;

    public HeaderInterceptor(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        HttpUrl host = HttpUrl.parse((String)String.format("https://lmfur57mca.execute-api.ap-northeast-2.amazonaws.com/%s/", this.preferences.getString("layer", "dev")));
        HttpUrl newUrl = null;
        try {
            newUrl = chain.request().url().newBuilder().scheme(host.scheme()).host(host.url().toURI().getHost()).port(host.port()).build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            newUrl = host;
        }
        Request.Builder builder = chain.request().newBuilder().url(newUrl).addHeader("x-api-key", this.preferences.getString("x-api-key", "")).addHeader("Content-Type", "application/json");
        if (!newUrl.url().getPath().contains("signUp")) {
            builder = builder.addHeader("Authorization", this.preferences.getString("token", ""));
        }
        Log.i((String)"HeaderInterceptor", (String)("x_API : " + this.preferences.getString("x-api-key", "")));
        return chain.proceed(builder.build());
    }
}

