package com.tenqube.visual_scraper.scrap.mall;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;


public class FactoryMall {

    public static Mall create(@NonNull String mName, ScrapRepository repository, WebViewManager webViewManager) {

        switch (MatchMallName(mName)) {

            case Constants.DEFAULT_MALL.Auction:
                return new Auction(Constants.DEFAULT_MALL.Auction, repository, webViewManager);

            case Constants.DEFAULT_MALL.Coupang:
                return new Coupang(Constants.DEFAULT_MALL.Coupang, repository, webViewManager);

            case Constants.DEFAULT_MALL.ElevenStreet:
                return new ElevenStreet(Constants.DEFAULT_MALL.ElevenStreet, repository, webViewManager);

            case Constants.DEFAULT_MALL.Gmarket:
                return new Gmarket(Constants.DEFAULT_MALL.Gmarket, repository, webViewManager);

            case Constants.DEFAULT_MALL.Gshome:
                return new Gshome(Constants.DEFAULT_MALL.Gshome, repository, webViewManager);

            case Constants.DEFAULT_MALL.Hmall:
                return new Hmall(Constants.DEFAULT_MALL.Hmall, repository, webViewManager);

            case Constants.DEFAULT_MALL.Interpark:
                return new Interpark(Constants.DEFAULT_MALL.Interpark, repository, webViewManager);

            case Constants.DEFAULT_MALL.LotteHome:
                return new LotteHome(Constants.DEFAULT_MALL.LotteHome, repository, webViewManager);

            case Constants.DEFAULT_MALL.NaverPay:
                return new Naver(Constants.DEFAULT_MALL.NaverPay, repository, webViewManager);

            case Constants.DEFAULT_MALL.Tmon:
                return new Tmon(Constants.DEFAULT_MALL.Tmon, repository, webViewManager);

            case Constants.DEFAULT_MALL.Wemake:
                return new Wemake(Constants.DEFAULT_MALL.Wemake, repository, webViewManager);

//
        }


        return null;

    }

    /**
     * mall name -> DEFAULT NAME 으로 변경
     * @param mallName
     * @return
     */
    private static String MatchMallName(@NonNull String mallName) {
        Log.i("MatchMallName","name : "+mallName);
        switch (mallName) {
            case Constants.DEFAULT_MALL.Auction :
            case "옥션" :
                return Constants.DEFAULT_MALL.Auction;
            case Constants.DEFAULT_MALL.Coupang :
            case "쿠팡" :
                return Constants.DEFAULT_MALL.Coupang;
            case Constants.DEFAULT_MALL.ElevenStreet:
            case "11번가" :
            return Constants.DEFAULT_MALL.ElevenStreet;
            case Constants.DEFAULT_MALL.Gmarket :
            case "G마켓" :
                return Constants.DEFAULT_MALL.Gmarket;
            case Constants.DEFAULT_MALL.Gshome :
            case "GS홈쇼핑" :
                return Constants.DEFAULT_MALL.Gshome;
            case Constants.DEFAULT_MALL.Hmall :
                return Constants.DEFAULT_MALL.Hmall;
            case Constants.DEFAULT_MALL.Interpark:
            case "인터파크" :
                return Constants.DEFAULT_MALL.Interpark;
            case Constants.DEFAULT_MALL.LotteHome :
            case "롯데홈쇼핑":
                return Constants.DEFAULT_MALL.LotteHome;
            case Constants.DEFAULT_MALL.NaverPay :
            case "네이버페이":
                return Constants.DEFAULT_MALL.NaverPay;
            case Constants.DEFAULT_MALL.Tmon :
            case "티몬" :
                return Constants.DEFAULT_MALL.Tmon;
            case Constants.DEFAULT_MALL.Wemake :
            case "위메프" :
                return Constants.DEFAULT_MALL.Wemake;
            default:
                return "";
        }
    }
}
