/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.tenqube.visual_scraper.scrap.OnPurchaseResult;
import com.tenqube.visual_scraper.scrap.login.ApiLogin;
import com.tenqube.visual_scraper.scrap.login.LoginService;
import com.tenqube.visual_scraper.scrap.login.WebViewLogin;
import com.tenqube.visual_scraper.scrap.mall.MallParser;
import com.tenqube.visual_scraper.scrap.mall.Parser;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.vo.ParsingRuleData;
import com.tenqube.visual_scraper.vo.api.RequestDocumentData;

public class Scraper {
    private static final String TAG = Scraper.class.getSimpleName();
    private Parser mParser;
    private OnPurchaseResult mListener;
    private LoginService mLogin;
    public static Boolean SCRAPING_DEBUG_MODE = false;
    private Context mContext;
    private AppExecutors appExecutors;

    public Scraper(@NonNull Context context, @NonNull ParsingRuleData parsingRuleData, @NonNull OnPurchaseResult listener, boolean debugMode) {
        this.mContext = context;
        this.mListener = listener;
        SCRAPING_DEBUG_MODE = debugMode;
        this.mLogin = parsingRuleData.getScrap().getIsWebviewLogin() == 0 ? new ApiLogin(parsingRuleData) : new WebViewLogin(this.mContext, parsingRuleData);
        this.mParser = new MallParser(parsingRuleData);
        this.appExecutors = new AppExecutors();
    }

    public void start() {
        Log.i((String)TAG, (String)"start");
        Runnable runnable = () -> this.mLogin.login(new LoginService.OnLoginCallback(){

            @Override
            public void onLoginSuccess(String cookie) {
                Log.i((String)TAG, (String)("onLoginSuccess cookie : " + cookie));
                Scraper.this.parse(cookie);
            }

            @Override
            public void onLoginFail(int statusCode, String statusMessage) {
                Log.i((String)TAG, (String)("onLoginFail statusMessage : " + statusMessage));
                Scraper.this.mListener.onLoginFail(statusCode, statusMessage);
            }
        });
        this.appExecutors.networkIO().execute(runnable);
    }

    private void parse(String cookie) {
        Runnable runnable = () -> this.mParser.parse(cookie, new Parser.OnResponsePurchasePage(){

            @Override
            public void onPurchasePageResult(RequestDocumentData documents) {
                Log.i((String)TAG, (String)("onPurchasePageResult : " + documents.contents.size()));
                Scraper.this.mListener.onPurchaseFinished("done", documents);
            }

            @Override
            public void onParsingFail(String message) {
                Scraper.this.mListener.onFail(400, message);
            }
        });
        this.appExecutors.networkIO().execute(runnable);
    }
}

