/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.model.view;

import com.tenqube.visual_scraper.db.entity.OrderWebRuleJson;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;

public class OrderWebRule {
    private final int id;
    private final int mallId;
    private final QueryRuleBody url;
    private final String requestBody;
    private final int requestMethod;
    private final QueryRuleBody periodScripts;
    private final ParsingOrderRules container;
    private final ParsingOrderRules title;
    private final ParsingOrderRules orderDate;
    private final ParsingOrderRules orderHms;
    private final ParsingOrderRules orderOption;
    private final ParsingOrderRules quantity;
    private final ParsingOrderRules price;
    private final ParsingOrderRules orderNum;
    private final ParsingOrderRules orderState;
    private final ParsingOrderRules imgUrl;
    private final ParsingOrderRules detailOrderLink;
    private final ParsingOrderRules detailProductLink;

    public OrderWebRule(OrderWebRuleJson orderWebRuleJson) {
        this.id = orderWebRuleJson.getId();
        this.mallId = orderWebRuleJson.getMallId();
        this.url = Utils.parseJsonObject(orderWebRuleJson.getUrl(), QueryRuleBody.class);
        this.requestBody = orderWebRuleJson.getRequestBody();
        this.requestMethod = orderWebRuleJson.getRequestMethod();
        this.periodScripts = Utils.parseJsonObject(orderWebRuleJson.getPeriodScripts(), QueryRuleBody.class);
        this.container = Utils.parseJsonObject(orderWebRuleJson.getContainer(), ParsingOrderRules.class);
        this.title = Utils.parseJsonObject(orderWebRuleJson.getTitle(), ParsingOrderRules.class);
        this.orderDate = Utils.parseJsonObject(orderWebRuleJson.getOrderDate(), ParsingOrderRules.class);
        this.orderHms = Utils.parseJsonObject(orderWebRuleJson.getOrderHms(), ParsingOrderRules.class);
        this.orderOption = Utils.parseJsonObject(orderWebRuleJson.getOrderOption(), ParsingOrderRules.class);
        this.quantity = Utils.parseJsonObject(orderWebRuleJson.getQuantity(), ParsingOrderRules.class);
        this.price = Utils.parseJsonObject(orderWebRuleJson.getPrice(), ParsingOrderRules.class);
        this.orderNum = Utils.parseJsonObject(orderWebRuleJson.getOrderNum(), ParsingOrderRules.class);
        this.orderState = Utils.parseJsonObject(orderWebRuleJson.getOrderState(), ParsingOrderRules.class);
        this.imgUrl = Utils.parseJsonObject(orderWebRuleJson.getImgUrl(), ParsingOrderRules.class);
        this.detailOrderLink = Utils.parseJsonObject(orderWebRuleJson.getDetailOrderLink(), ParsingOrderRules.class);
        this.detailProductLink = Utils.parseJsonObject(orderWebRuleJson.getDetailProductLink(), ParsingOrderRules.class);
    }

    public int getId() {
        return this.id;
    }

    public int getMallId() {
        return this.mallId;
    }

    public QueryRuleBody getUrl() {
        return this.url;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public int getRequestMethod() {
        return this.requestMethod;
    }

    public QueryRuleBody getPeriodScripts() {
        return this.periodScripts;
    }

    public ParsingOrderRules getContainer() {
        return this.container;
    }

    public ParsingOrderRules getTitle() {
        return this.title;
    }

    public ParsingOrderRules getOrderDate() {
        return this.orderDate;
    }

    public ParsingOrderRules getOrderHms() {
        return this.orderHms;
    }

    public ParsingOrderRules getOrderOption() {
        return this.orderOption;
    }

    public ParsingOrderRules getQuantity() {
        return this.quantity;
    }

    public ParsingOrderRules getPrice() {
        return this.price;
    }

    public ParsingOrderRules getOrderNum() {
        return this.orderNum;
    }

    public ParsingOrderRules getOrderState() {
        return this.orderState;
    }

    public ParsingOrderRules getImgUrl() {
        return this.imgUrl;
    }

    public ParsingOrderRules getDetailOrderLink() {
        return this.detailOrderLink;
    }

    public ParsingOrderRules getDetailProductLink() {
        return this.detailProductLink;
    }

    public String toString() {
        return "OrderWebRule{id=" + this.id + ", mallId=" + this.mallId + ", url=" + this.url + ", requestBody='" + this.requestBody + '\'' + ", requestMethod=" + this.requestMethod + ", periodScripts=" + this.periodScripts + ", container=" + this.container + ", title=" + this.title + ", orderDate=" + this.orderDate + ", orderHms=" + this.orderHms + ", orderOption=" + this.orderOption + ", quantity=" + this.quantity + ", price=" + this.price + ", orderNum=" + this.orderNum + ", orderState=" + this.orderState + ", imgUrl=" + this.imgUrl + ", detailOrderLink=" + this.detailOrderLink + ", detailProductLink=" + this.detailProductLink + '}';
    }
}

