/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import java.util.Timer;
import java.util.TimerTask;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class WebViewManager {
    private static final long TIMEOUT_TIMEMILLIS = 30000L;
    private Mall mall;
    private WebView webView;
    private Context context;
    private Handler handler;
    private CookieManager cookieManager;
    private WebViewCallback callback;
    private Timer timer;
    private Timer tempTimer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();
    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;
    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    private int failedCnt = 0;
    private boolean isFinishedCallback;
    private MallViewService mallViewService;
    private boolean isVisibleWebView;
    private boolean isLoginFinished;
    private boolean isCheckedCaptcha;

    @SuppressLint(value={"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context, MallViewService mallViewService) {
        this.context = context;
        this.handler = new Handler();
        this.mallViewService = mallViewService;
        this.initWebView();
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {
        this.webView = new WebView(this.context);
        this.createCookieManager();
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
        this.webView.addJavascriptInterface((Object)new ScriptInterface(), "HtmlViewer");
        this.webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.webView.getSettings().setMixedContentMode(2);
        }
        this.webView.setLayerType(1, null);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.i((String)"onReceivedError", (String)("error : " + error));
                WebViewManager.this.stopTimer();
                if (Build.VERSION.SDK_INT >= 23) {
                    switch (error.getErrorCode()) {
                        case -10: {
                            return;
                        }
                    }
                }
                new Handler(Looper.getMainLooper()).post(() -> {
                    if (Build.VERSION.SDK_INT >= 23) {
                        WebViewManager.this.callback.onFail(error.getErrorCode(), error.getDescription().toString());
                    } else {
                        WebViewManager.this.callback.onFail(403, error.toString());
                    }
                });
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Log.i((String)"onPageFinished", (String)("url : " + url));
                WebViewManager.this.onPageFinishedCallback(view, url);
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Log.i((String)"onJsAlert", (String)("message : " + message + "url : " + url));
                WebViewManager.this.LoginFailed(message);
                result.confirm();
                return true;
            }
        });
    }

    private void onPageFinishedCallback(WebView view, String url) {
        if (this.action == 1 && this.isLoginFinished) {
            return;
        }
        if ("about:blank".equals(url) && view.getTag() != null) {
            view.loadUrl(view.getTag().toString());
            return;
        }
        view.setTag((Object)url);
        this.stopTimer();
        if (this.scripts != null) {
            this.loadScripts(this.scripts);
            this.tempScripts = this.scripts;
            this.scripts = null;
            this.isFinishedCallback = true;
        } else if (this.action == 1) {
            if (url.contains(this.webUrl) || this.mall.identifyLoginPageOrNot(url)) {
                Log.i((String)"scripts fail", (String)("!! " + this.failedCnt + " " + this.isVisibleWebView));
                if (this.mall.doCheckLoginError() || this.mall.doCheckLoginCaptcha() && !this.isVisibleWebView && !this.isCheckedCaptcha) {
                    this.getLoginHtml();
                } else if (!this.isVisibleWebView) {
                    this.retryLogin();
                }
            } else {
                this.failedCnt = 0;
                if (this.isVisibleWebView) {
                    new Handler(Looper.getMainLooper()).post(() -> {
                        this.mallViewService.setWebView(this.webView, 8);
                        this.isVisibleWebView = false;
                    });
                }
                this.finish();
            }
        } else {
            if (this.action == 2 && (url.contains("main") || url.contains("Home") || url.contains("www.naver.com"))) {
                Log.i((String)"page", (String)"Pass!!!!!!!");
                return;
            }
            this.failedCnt = 0;
            this.finish();
        }
    }

    private void retryLogin() {
        ++this.failedCnt;
        Log.i((String)"retryLogin", (String)("failedCnt : " + this.failedCnt));
        if (this.failedCnt == 5) {
            this.callback.onFail(400, "\ub85c\uadf8\uc778 \uc2e4\ud328 5\ubc88");
            this.closeWebView();
            return;
        }
        this.loadScripts(this.tempScripts);
    }

    private void sycCookie() {
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.getInstance().sync();
        } else {
            CookieManager.getInstance().flush();
        }
    }

    private void finish() {
        Log.i((String)"webview", (String)("finish " + this.action));
        if (this.callback != null) {
            switch (this.action) {
                case 0: {
                    this.callback.onResult(this.webUrl, this.webView);
                    break;
                }
                case 1: {
                    new Handler(Looper.getMainLooper()).post(() -> {
                        if (this.checkLoginState()) {
                            Toast.makeText((Context)this.context, (CharSequence)"Login finished", (int)0).show();
                            this.failedCnt = 0;
                            this.isLoginFinished = true;
                            this.callback.onResult(this.cookieManager.getCookie(this.webUrl), this.webView);
                        } else {
                            this.callback.onFail(403, "\ub85c\uadf8\uc778 \uc2e4\ud328");
                            this.closeWebView();
                        }
                    });
                    break;
                }
                case 2: {
                    this.getHtml();
                }
            }
        }
    }

    private boolean findCapchaImage(Document document) {
        this.isCheckedCaptcha = true;
        if (this.mall.checkCaptchaImage(document)) {
            Log.i((String)"checkHTML", (String)"captcha");
            new Handler(Looper.getMainLooper()).post(() -> {
                this.isVisibleWebView = true;
                this.mallViewService.setWebView(this.webView, 0);
            });
            return true;
        }
        return false;
    }

    @JavascriptInterface
    private void getHtml() {
        this.webView.loadUrl("javascript:window.HtmlViewer.showHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }

    @JavascriptInterface
    private void getLoginHtml() {
        Log.i((String)"getLoginHtml", (String)"!!");
        this.handler.post(() -> this.webView.loadUrl("javascript:window.HtmlViewer.checkHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');"));
    }

    private void LoginFailed(String error) {
        new Handler(Looper.getMainLooper()).post(() -> {
            this.isLoginFinished = true;
            this.stopTimer();
            Toast.makeText((Context)this.context, (CharSequence)("" + error), (int)1).show();
            this.callback.onFail(400, "\ub85c\uadf8\uc778 \uc624\ub958");
            this.closeWebView();
        });
    }

    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (this.webUrl != null) {
            this.isLoginFinished = false;
            this.loadWebView(this.webUrl, false);
        } else {
            callback.onFail(403, "webUrl does not exist");
            this.closeWebView();
        }
    }

    public void setMall(Mall mall) {
        this.mall = mall;
    }

    private void loadScripts(String scripts) {
        try {
            Log.i((String)"loadScripts", (String)("scripts \uc2e4\ud589 " + scripts));
            Toast.makeText((Context)this.context, (CharSequence)("loadScripts : " + scripts), (int)0).show();
            this.loadWebView(scripts, true);
            this.tempTimer = this.timer;
            Log.i((String)"TEST", (String)("temp : " + this.tempTimer + "//" + this.timer + "/" + this.timerTask));
            if (this.failedCnt > 2) {
                return;
            }
            this.handler.postDelayed(() -> {
                Log.i((String)"TESTT", (String)("temp : " + this.tempTimer + "//" + this.timer + "/" + this.timerTask));
                if (this.action == 1 && this.timer != null) {
                    Log.i((String)"loadScripts", (String)"OnPageFinished \uc548\uc6b8\ub9bc , \ub85c\uadf8\uc778 \uc624\ub958 \uccb4\ud06c ");
                    this.stopTimer();
                    this.getLoginHtml();
                }
                if (this.action == 2 && this.timer != null && this.mall.doParsingMall()) {
                    this.stopTimer();
                    if (this.isFinishedCallback) {
                        this.finish();
                    }
                }
            }, 10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.onFail(403, e.toString());
            this.closeWebView();
        }
    }

    private boolean checkLoginState() {
        return this.cookieManager.getCookie(this.webUrl) != null;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        Log.i((String)"loadWebView", (String)("url :" + urlOrScripts + " //\nisScript : " + isScripts + "//" + this.scripts));
        this.startTimer();
        this.handler.postDelayed(() -> this.webView.loadUrl(urlOrScripts, null), 0L);
    }

    private WebViewManager createCookieManager() {
        this.cookieManager = CookieManager.getInstance();
        this.cookieManager.setAcceptCookie(true);
        this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.webView.getSettings().setSafeBrowsingEnabled(false);
        }
        return this;
    }

    private void closeWebView() {
        Log.i((String)"closeWebView", (String)"!!");
        if (this.webView != null) {
            this.handler.post(() -> {
                if (this.action == 1) {
                    this.isLoginFinished = true;
                }
                this.failedCnt = 0;
                this.isFinishedCallback = false;
                this.webView.stopLoading();
                this.webView.clearCache(true);
                this.webView.clearHistory();
                if (this.cookieManager != null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.cookieManager.removeSessionCookies(value -> {});
                    } else {
                        this.cookieManager.removeSessionCookie();
                    }
                    this.cookieManager.removeAllCookie();
                }
            });
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.timerTask = null;
        }
    }

    public WebView getWebView() {
        return this.webView;
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                WebViewManager.this.mTimerHandler.post(() -> {
                    Log.i((String)"TimeOut", (String)("action : " + WebViewManager.this.action + "/url : " + WebViewManager.this.webUrl + " scripts : " + WebViewManager.this.scripts));
                    WebViewManager.this.stopTimer();
                    if (WebViewManager.this.isFinishedCallback) {
                        WebViewManager.this.finish();
                        return;
                    }
                    WebViewManager.this.closeWebView();
                    WebViewManager.this.callback.onFail(403, "Timeout Fail");
                });
            }
        };
        this.timer.schedule(this.timerTask, 30000L);
    }

    public static interface WebViewCallback {
        public void onResult(String var1, WebView var2);

        public void onFail(int var1, String var2);
    }

    class ScriptInterface {
        ScriptInterface() {
        }

        @JavascriptInterface
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public void showHTML(String html) {
            Log.i((String)"showHTML", (String)("html : " + html));
            if (WebViewManager.this.callback != null) {
                WebViewManager.this.callback.onResult(html, WebViewManager.this.webView);
                Toast.makeText((Context)WebViewManager.this.context, (CharSequence)"finish", (int)0).show();
                WebViewManager.this.closeWebView();
            }
        }

        @JavascriptInterface
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public void checkHTML(String html) {
            Log.i((String)"checkHTML", (String)("html : " + html));
            Document document = Jsoup.parse((String)html);
            if (document == null) {
                return;
            }
            if (WebViewManager.this.mall.doCheckLoginError()) {
                String error = WebViewManager.this.mall.checkLoginError(document);
                Log.i((String)"checkHTML", (String)("error : " + error));
                if (!TextUtils.isEmpty((CharSequence)error)) {
                    WebViewManager.this.LoginFailed(error);
                } else if (WebViewManager.this.mall.doCheckLoginCaptcha()) {
                    if (!WebViewManager.this.findCapchaImage(document)) {
                        WebViewManager.this.retryLogin();
                    }
                } else {
                    WebViewManager.this.retryLogin();
                }
            } else if (WebViewManager.this.mall.doCheckLoginCaptcha() && !WebViewManager.this.findCapchaImage(document)) {
                WebViewManager.this.retryLogin();
            }
        }
    }
}

