/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import java.util.ArrayList;
import java.util.List;

public class UserDao_Impl
implements UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfUserEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserLastScrapAt;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserIsLogin;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `users`(`u_id`,`mall_id`,`user_id`,`pwd`,`cookie`,`is_login`,`is_progress`,`last_scrap_at`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                stmt.bindLong(1, (long)value.getId());
                stmt.bindLong(2, (long)value.getMallId());
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getUserPwd() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getUserPwd());
                }
                if (value.getCookie() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCookie());
                }
                int _tmp = value.isLogin() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                int _tmp_1 = value.isProgress() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                stmt.bindLong(8, value.getLastScrapAt());
            }
        };
        this.__preparedStmtOfUpdateUserLastScrapAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE users SET last_scrap_at = ? WHERE mall_id = ? AND user_id = ?";
                return "UPDATE users SET last_scrap_at = ? WHERE mall_id = ? AND user_id = ?";
            }
        };
        this.__preparedStmtOfUpdateUserIsLogin = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE users SET is_login = ? WHERE mall_id = ?";
                return "UPDATE users SET is_login = ? WHERE mall_id = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(UserEntity user) {
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfUserEntity.insertAndReturnId((Object)user);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserLastScrapAt(long lastScrapAt, int mallId, String userId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserLastScrapAt.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, lastScrapAt);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, (long)mallId);
            _argIndex = 3;
            if (userId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, userId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserLastScrapAt.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateUserIsLogin(int mallId, boolean isLogin) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserIsLogin.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            int _tmp = isLogin ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, (long)mallId);
            long _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserIsLogin.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserEntity> getUsers() {
        String _sql = "SELECT * FROM users ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM users ", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("u_id");
            int _cursorIndexOfMallId = _cursor.getColumnIndexOrThrow("mall_id");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("user_id");
            int _cursorIndexOfUserPwd = _cursor.getColumnIndexOrThrow("pwd");
            int _cursorIndexOfCookie = _cursor.getColumnIndexOrThrow("cookie");
            int _cursorIndexOfIsLogin = _cursor.getColumnIndexOrThrow("is_login");
            int _cursorIndexOfIsProgress = _cursor.getColumnIndexOrThrow("is_progress");
            int _cursorIndexOfLastScrapAt = _cursor.getColumnIndexOrThrow("last_scrap_at");
            ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmpUserPwd = _cursor.getString(_cursorIndexOfUserPwd);
                UserEntity _item = new UserEntity(_tmpMallId, _tmpUserId, _tmpUserPwd);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpCookie = _cursor.getString(_cursorIndexOfCookie);
                _item.setCookie(_tmpCookie);
                int _tmp = _cursor.getInt(_cursorIndexOfIsLogin);
                boolean _tmpIsLogin = _tmp != 0;
                _item.setLogin(_tmpIsLogin);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsProgress);
                boolean _tmpIsProgress = _tmp_1 != 0;
                _item.setProgress(_tmpIsProgress);
                long _tmpLastScrapAt = _cursor.getLong(_cursorIndexOfLastScrapAt);
                _item.setLastScrapAt(_tmpLastScrapAt);
                _result.add(_item);
            }
            ArrayList<UserEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

