/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;
import android.content.res.AssetManager;
import android.support.annotation.NonNull;
import android.util.Log;
import com.tenqube.visual_scraper.db.Converters;
import com.tenqube.visual_scraper.db.DataGenerator;
import com.tenqube.visual_scraper.db.dao.LoginApiRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginWebRuleDao;
import com.tenqube.visual_scraper.db.dao.MallDao;
import com.tenqube.visual_scraper.db.dao.MallWithUserDao;
import com.tenqube.visual_scraper.db.dao.OrderApiRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.OrderDetailWebRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderWebRuleDao;
import com.tenqube.visual_scraper.db.dao.RuleDao;
import com.tenqube.visual_scraper.db.dao.ScrapDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.RuleEntity;
import com.tenqube.visual_scraper.db.entity.ScrapEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.LoginApiRule;
import com.tenqube.visual_scraper.db.entity.newEntity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.newEntity.MallEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderDetailWebRule;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderWebRuleJson;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.model.jsonParsing.MallScrapInfo;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.Utils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

@Database(entities={ScrapEntity.class, UserEntity.class, OrderEntity.class, RuleEntity.class, MallEntity.class, LoginApiRule.class, LoginWebRule.class, OrderApiRuleJson.class, OrderWebRuleJson.class, OrderDetailWebRule.class}, version=1, exportSchema=false)
@TypeConverters(value={Converters.class})
public abstract class ScraperDatabase
extends RoomDatabase {
    public static final String DATABASE_NAME = "online_malls";
    private static ScraperDatabase sInstance;
    private final MutableLiveData<Boolean> mIsDatabaseCreated = new MutableLiveData();

    public abstract ScrapDao scrapDao();

    public abstract UserDao userDao();

    public abstract OrderDao orderDao();

    public abstract RuleDao ruleDao();

    public abstract UserWithOrdersDao userWithOrdersDao();

    public abstract MallWithUserDao mallWithUserDao();

    public abstract MallDao mallDao();

    public abstract LoginRuleDao loginRuleDao();

    public abstract LoginWebRuleDao loginWebRuleDao();

    public abstract LoginApiRuleDao loginApiRuleDao();

    public abstract OrderApiRuleDao orderApiRuleDao();

    public abstract OrderWebRuleDao orderWebRuleDao();

    public abstract OrderDetailWebRuleDao orderDetailWebRuleDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScraperDatabase getInstance(Context context, AppExecutors executors) {
        if (sInstance != null) return sInstance;
        Class<ScraperDatabase> clazz = ScraperDatabase.class;
        synchronized (ScraperDatabase.class) {
            if (sInstance != null) return sInstance;
            sInstance = ScraperDatabase.buildDatabase(context.getApplicationContext(), executors);
            sInstance.updateDatabaseCreated(context.getApplicationContext());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private static ScraperDatabase buildDatabase(final Context appContext, final AppExecutors executors) {
        return (ScraperDatabase)Room.databaseBuilder((Context)appContext, ScraperDatabase.class, (String)DATABASE_NAME).addCallback(new RoomDatabase.Callback(){

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                super.onCreate(db);
                executors.diskIO().execute(() -> {
                    ScraperDatabase.addDelay();
                    ScraperDatabase database = ScraperDatabase.getInstance(appContext, executors);
                    List<ScrapEntity> scrapEntities = DataGenerator.generateScraps();
                    ScraperDatabase.insertData(appContext, database, scrapEntities);
                    database.setDatabaseCreated();
                });
            }
        }).build();
    }

    private void updateDatabaseCreated(Context context) {
        if (context.getDatabasePath(DATABASE_NAME).exists()) {
            this.setDatabaseCreated();
        }
    }

    private void setDatabaseCreated() {
        this.mIsDatabaseCreated.postValue((Object)true);
    }

    private static void insertData(Context appContext, ScraperDatabase database, List<ScrapEntity> scrapEntities) {
        database.runInTransaction(() -> database.scrapDao().inserts(scrapEntities));
    }

    private static void getJsonMallScraps(Context context, ScraperDatabase database) {
        String jsonStr = Utils.loadJSONFromAsset(context, "mall_info.json");
        try {
            Log.i((String)"array", (String)("jsonStr : " + jsonStr));
            MallScrapInfo mallScrapInfo = Utils.fromJson(jsonStr, MallScrapInfo.class);
            Log.i((String)"getJsonMallScraps", (String)("mall_info : " + mallScrapInfo));
            database.mallDao().insertList(mallScrapInfo.getMalls());
            if (mallScrapInfo.getLoginJsonRules() != null) {
                database.loginApiRuleDao().insert(mallScrapInfo.getLoginJsonRules());
            }
            database.loginWebRuleDao().insertList(mallScrapInfo.getLoginHtmlRules());
            database.orderApiRuleDao().insert(mallScrapInfo.getOrderJsonRules());
            database.orderWebRuleDao().insertList(mallScrapInfo.getOrderHtmlRules());
            Log.i((String)"getJsonMallScraps", (String)("getMalls : " + mallScrapInfo.getMalls()));
            Log.i((String)"getJsonMallScraps", (String)("getLoginJsonRules : " + mallScrapInfo.getLoginJsonRules()));
            Log.i((String)"getJsonMallScraps", (String)("getLoginHtmlRules : " + mallScrapInfo.getLoginHtmlRules()));
            Log.i((String)"getJsonMallScraps", (String)("getOrderJsonRules : " + mallScrapInfo.getOrderJsonRules()));
            Log.i((String)"getJsonMallScraps", (String)("getOrderHtmlRules : " + mallScrapInfo.getOrderHtmlRules()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertOrderRules(Context mContext, ScraperDatabase database) {
        ArrayList<RuleEntity> ruleEntityList = new ArrayList<RuleEntity>();
        AssetManager am = mContext.getAssets();
        int i = 0;
        try {
            String line;
            InputStream inStream = am.open("order_rules_by_hyewon.tsv");
            BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
            while ((line = buffer.readLine()) != null) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                String[] colums = line.split("\t");
                RuleEntity rule = new RuleEntity(Integer.parseInt(colums[0]), colums[1], colums[4], colums[5], colums[6], colums[7], colums[8], colums[9], colums[10], colums[11], colums[12], colums[13], colums[14], colums[15]);
                Log.i((String)"insert_rules", (String)("rule : " + rule));
                ruleEntityList.add(rule);
                ++i;
            }
            if (ruleEntityList.size() > 0) {
                List<Long> ids = database.ruleDao().insertList(ruleEntityList);
                Log.i((String)"insertList", (String)("ids : " + ids.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addDelay() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public LiveData<Boolean> getDatabaseCreated() {
        return this.mIsDatabaseCreated;
    }
}

