package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.scrap.mall.Mall;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.Timer;
import java.util.TimerTask;

public class WebViewManager {

    private static final long TIMEOUT_TIMEMILLIS = 30000;

    private Mall mall;
    private WebView webView;
    private Context context;
    private Handler handler;
    private CookieManager cookieManager;

    private WebViewCallback callback;
    private Timer timer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();

    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;

    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    private int failedCnt = 0;
    private boolean isFinishedCallback;
    private MallViewService mallViewService;
    private boolean isVisibleWebView;


    @SuppressLint({"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context, MallViewService mallViewService /*, WebView view*/) {
        this.context = context;
        this.handler = new Handler();
        this.mallViewService = mallViewService;
        initWebView();
    }

    @SuppressLint({"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {
        this.webView = /*view == null ? */new WebView(context) /*: view*/;
        createCookieManager();
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setUserAgentString(Constants.USER_AGENT);

        webView.addJavascriptInterface(new ScriptInterface(), "HtmlViewer");
        webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) webView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
        webView.setLayerType(WebView.LAYER_TYPE_SOFTWARE, null);
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.i("onReceivedError","error : "+error);

                stopTimer();
//                closeWebView();

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    switch (error.getErrorCode()) {
                        case ERROR_UNSUPPORTED_SCHEME:
                            return;
                }}

                new Handler(Looper.getMainLooper()).post(() -> {

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {

                        callback.onFail(error.getErrorCode(), error.getDescription().toString());
                    } else {
                        callback.onFail(403, error.toString());
                    }
                });

            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Log.i("onPageFinished","url : "+url);

                onPageFinishedCallback(view, url);

            }

//            @Override
//            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
//                Log.i("isRedirect","!!"+request.isRedirect());
//                view.loadUrl(request.getUrl());
//
//            }

        });
    }

    private void onPageFinishedCallback(WebView view, String url) {
        if ("about:blank".equals(url) && view.getTag() != null) {
            view.loadUrl(view.getTag().toString());
            return;
        } else {
            view.setTag(url);
        }

//      sycCookie();
        stopTimer();


        if(/*url.contains(webUrl) && */scripts != null){
            loadScripts(scripts);
            tempScripts = scripts;
            scripts = null;
            isFinishedCallback = true;
        } else if(action == LOGIN/* && scripts == null*/){

            if (url.contains(webUrl) || url.contains("Login") || url.contains("login") /*|| url.contains("https://nid.naver.com/signin/")*/){
                // 로그인 실패
                Log.i("scripts fail","!!");
                // Captcha check
                if (failedCnt ==0) {
                    getLoginHtml();
                    failedCnt++;
                } else {
                    if (!isVisibleWebView) retryLogin();
                }


            } else {
                // 로그인 성공
                failedCnt = 0;
                if (isVisibleWebView) {
                    mallViewService.setWebView(webView, View.GONE);
                    isVisibleWebView = false;
                }
                finish();
            }
        } else {
            if (action == ORDER_PARSING &&  (url.contains("main") || url.contains("Home") || (url.contains("www.naver.com") ))) {
                Log.i("page","Pass!!!!!!!");
//                        startTimer();
                return;
            }
            failedCnt = 0;
            finish();
        }
    }

    private void retryLogin() {

        failedCnt++;

        if (failedCnt == 5){
            callback.onFail(400, "로그인 실패 5번"); // 실패
            return;
        }
        loadScripts(tempScripts);
    }

    private void sycCookie() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            CookieSyncManager.getInstance().sync();
        } else {
            CookieManager.getInstance().flush();
        }

    }

    private void finish() {
        Log.i("webview","finish");
        Toast.makeText(context, "finish", Toast.LENGTH_SHORT).show();
        if (callback != null) {
            switch (action) {
                case DEFAULT :
                    callback.onResult(webUrl, webView);
                    break;
                case LOGIN :
                    new Handler(Looper.getMainLooper()).post(() -> {

                        if (checkLoginState()){
                            callback.onResult(cookieManager.getCookie(webUrl), webView); // 성공
                        } else {
                            callback.onFail(403, "로그인 실패");
                        }
                    });
                    break;

                case ORDER_PARSING :
                    // html 가져오기
                    getHtml();
//                    closeWebView();
                    break;
            }
        }
    }

    class ScriptInterface {

        ScriptInterface() {
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void showHTML(String html) {
            Log.i("showHTML", "html : "+html);
            if (callback != null) {
                callback.onResult(html, webView);
                closeWebView();
            }
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void checkHTML(String html) {
            Log.i("checkHTML", "html : "+html);

            Document document = Jsoup.parse(html);
            if (document == null) return;

            String error = mall.checkLoginError(document);
            Log.i("checkHTML", "error : "+error);
            if (!TextUtils.isEmpty(error)) {
                // 로그인 오류
                new Handler(Looper.getMainLooper()).post(() -> {

                    Toast.makeText(context, ""+error, Toast.LENGTH_SHORT).show();
                    callback.onFail(400, "로그인 오류");
                    closeWebView();
                });


            } else {
                //
                if (mall.checkCaptchaImage(document)){
                    // webView 띄우기
                    Log.i("checkHTML","captcha");
                    isVisibleWebView = true;
                    mallViewService.setWebView(webView, View.VISIBLE);

                    // login 모드  > 실패 혹은 성공시 finish 에서 판별 만들기 > callback return
//                callback.onFail(400, "로그인 실패 5번"); // 실패
//                callback.onResult(cookieManager.getCookie(webUrl), webView); // 성공


                } else {
                    retryLogin();
                }
            }

        }

    }

    @JavascriptInterface
    private void getHtml() {
        webView.loadUrl("javascript:window.HtmlViewer.showHTML" +
                "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }

    @JavascriptInterface
    private void getLoginHtml() {
        webView.loadUrl("javascript:window.HtmlViewer.checkHTML" +
                "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }


    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (webUrl != null){
            loadWebView(webUrl, false);
        } else {
            callback.onFail(403, "webUrl does not exist");
            closeWebView();
        }
    }

    public void setMall(Mall mall) {
        this.mall = mall;
    }

    private void loadScripts(String scripts) {
        Log.i("loadScripts","info : "+scripts);
        Toast.makeText(context, "loadScripts : "+scripts, Toast.LENGTH_SHORT).show();

        try {

            // 1. cookie 존재 유무 체크
//            if (checkLoginState()) {
//                // 1-1. cookie 존재 > Success
//                if (action == LOGIN){
//                    finish();
//                } else {
//                    // scripts 실행
//                    Log.i("loadScripts","scripts 실행 "+ scripts);
//                    loadWebView(scripts);
//                    scripts = null;
//                }
//            } else {
                // 1-2. cookie 존재 x  > 로그인 스크립트 실행
//                callback.onFail(403, "로그인 되어있지 않음");
                Log.i("loadScripts","scripts 실행 "+ scripts);
                loadWebView(scripts, true);
//            }
        } catch (Exception e) {
            e.printStackTrace();
            callback.onFail(403, e.toString());
            closeWebView();
        }
    }

    private boolean checkLoginState() {
        return cookieManager.getCookie(webUrl) != null;
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        Log.i("loadWebView","url :"+ urlOrScripts + " //\nisScript : "+ isScripts +"//" +scripts );
        startTimer();
        handler.postDelayed(() -> webView.loadUrl(urlOrScripts, null), /*isScripts? 1000 :*/ 0);
    }

     private WebViewManager createCookieManager() {
        cookieManager = CookieManager.getInstance();//.getCookieStore();
        cookieManager.setAcceptCookie(true);
        cookieManager.setAcceptThirdPartyCookies(webView, true);

         if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            webView.getSettings().setSafeBrowsingEnabled(false);
        }

        return this;
    }




    public interface WebViewCallback {
        void onResult(String item, WebView webView);
        void onFail(int statusCode, String statusMessage);
    }


    private void closeWebView() {
        Log.i("closeWebView","!!");
        if (webView != null) {
            handler.post(() -> {
                failedCnt = 0;
                isFinishedCallback = false;
                webView.stopLoading();
                webView.clearCache(true);
                webView.clearHistory();

                if (cookieManager != null) {

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        cookieManager.removeSessionCookies(value -> {
                        });
                    } else {
                        cookieManager.removeSessionCookie();
                    }
                    cookieManager.removeAllCookie();
                }
            });
        }
    }

    private void stopTimer(){
        if(timer != null){
            timer.cancel();
            timer.purge();
            timer = null;
            timerTask = null;
        }
    }

    public WebView getWebView(){
        return webView;
    }

    private void startTimer() {

        timer = new Timer();
        timerTask = new TimerTask() {
            @Override
            public void run() {

                mTimerHandler.post(() -> {

                    stopTimer();
                    if (isFinishedCallback) {
                        finish();
                        return;
                    }

                    closeWebView();
                    callback.onFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
                });

            }
        };
        timer.schedule(timerTask, TIMEOUT_TIMEMILLIS);

    }
}
