/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.entity.newEntity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_scraper.db.entity.newEntity.MallEntity;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;
import java.io.Serializable;

@Entity(tableName="login_web_rules", indices={@Index(value={"mall_id"}, unique=true)}, foreignKeys={@ForeignKey(entity=MallEntity.class, parentColumns={"m_id"}, childColumns={"mall_id"}, onDelete=5)})
public class LoginWebRule
implements Serializable {
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="id")
    private int id;
    @ColumnInfo(name="mall_id")
    private final String mallId;
    @ColumnInfo(name="web_url")
    private final String url;
    @ColumnInfo(name="loginScripts")
    private final String loginScripts;
    @ColumnInfo(name="captcha_container")
    private final String captchaContainer;
    @ColumnInfo(name="fail_message")
    private final String failMessage;
    @Ignore
    @ColumnInfo(name="scripts_body")
    private QueryRuleBody scriptsBody;
    @Ignore
    @ColumnInfo(name="url_body")
    private QueryRuleBody urlBody;

    public LoginWebRule(String mallId, String url, @NonNull String loginScripts, String captchaContainer, String failMessage) {
        this.mallId = mallId;
        this.url = url;
        this.loginScripts = loginScripts;
        this.captchaContainer = captchaContainer;
        this.failMessage = failMessage;
    }

    public int getId() {
        return this.id;
    }

    public String getMallId() {
        return this.mallId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLoginScripts() {
        return this.loginScripts;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    public QueryRuleBody getScriptsBody() {
        if (this.scriptsBody == null && !TextUtils.isEmpty((CharSequence)this.loginScripts)) {
            this.scriptsBody = Utils.fromJson(this.loginScripts, QueryRuleBody.class);
        }
        return this.scriptsBody;
    }

    public void setScriptsBody(QueryRuleBody scriptsBody) {
        this.scriptsBody = scriptsBody;
    }

    public QueryRuleBody getUrlBody() {
        if (this.urlBody == null && !TextUtils.isEmpty((CharSequence)this.url)) {
            this.urlBody = Utils.fromJson(this.url, QueryRuleBody.class);
        }
        return this.urlBody;
    }

    public void setUrlBody(QueryRuleBody urlBody) {
        this.urlBody = urlBody;
    }

    public String getCaptchaContainer() {
        return this.captchaContainer;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public String toString() {
        return "LoginWebRule{id=" + this.id + ", mallId='" + this.mallId + '\'' + ", url='" + this.url + '\'' + ", loginScripts='" + this.loginScripts + '\'' + ", captchaContainer='" + this.captchaContainer + '\'' + ", failMessage='" + this.failMessage + '\'' + ", scriptsBody=" + this.scriptsBody + ", urlBody=" + this.urlBody + '}';
    }
}

