package com.tenqube.visual_scraper.api;

import com.tenqube.visual_scraper.model.api.MallBody;
import com.tenqube.visual_scraper.model.api.RequestDocumentData;
import com.tenqube.visual_scraper.model.api.Orders;
import com.tenqube.visual_scraper.model.jsonParsing.MallScrapInfo;
import com.tenqube.visual_scraper.model.newApi.request.OrderBody;
import com.tenqube.visual_scraper.model.newApi.request.SaveOrdersBody;
import com.tenqube.visual_scraper.model.newApi.request.SignUpBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultSignUp;

import java.util.List;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Created by tenqube on 2018. 6. 14..
 */

public interface ScrapApiService {

    String BASE_URL = "https://lmfur57mca.execute-api.ap-northeast-2.amazonaws.com/%s/";//dev/";


    @POST("sign-up")
    Call<ResultBody<ResultSignUp>> callSignUpUser(@Body SignUpBody signUpBody);


    @GET("rules")
    Call<ResultBody<MallScrapInfo>> callGetRules();


    @POST("orders")
    Call<String> callSaveOrders(@Body SaveOrdersBody orders);






    /**
     * 파싱룰 서버 동기화
     * @param version 동기화 필드
     * @return
     */
    @GET("sync-rule/{version}")
    Call<MallBody> callScrapingRule(@Path("version")int version);

    /**
     *
     * @param requestDocumentData 주문페이지 데이터
     * @return Orders
     */
    @POST("purchase-parser")
    Call<Orders> callPurchaseParser(@Body RequestDocumentData requestDocumentData);


//    /**
//     *
//     * @param requestDocumentData 상세페이지 데이터
//     * @return OrderData
//     */
//    @POST("detail-parser")
//    ScrapCallAdapter.MyCall<Order> callDetailParser(@Body RequestDocumentData requestDocumentData);
//
//    /******************************************* SCRAPING ********************************************************/
//    @POST("orders")
//    ScrapCallAdapter.MyCall<Void> callOrders(@Body RequestOrders requestOrders);

}
