package com.tenqube.visual_scraper.utils;

import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Created by tenqube on 2018. 4. 30..cw.jeon
 */

public class DateUtils {

    public static final DecimalFormat decimalFormat = new DecimalFormat("00");// decimalformat은
    public static final DecimalFormat firstdF = new DecimalFormat("0.#");// decimalformat은

    public static final SimpleDateFormat SLASH_DATE_FORMAT = new SimpleDateFormat("yyyy/mm/dd", Locale.getDefault());

    public static final SimpleDateFormat DOT_DATE_FORMAT = new SimpleDateFormat("yyyy.mm.dd", Locale.getDefault());

    public static final SimpleDateFormat BASE_DATE_FORMAT = new SimpleDateFormat("yyyy-mm-dd", Locale.getDefault());

    public static final SimpleDateFormat BASE_HMS_FORMAT = new SimpleDateFormat("hh:mm:ss", Locale.getDefault());


    public static final String LAST_SCRAPT_AT_FORMAT = "yyyy-mm-dd";

    public static String getTodayDate() {
        Calendar cal = Calendar.getInstance();
        return getStringDateAsYYYYMMddHHmmss(cal);
    }

    public static Date transformDate(String date, Constants.DateFormatType formatType) {

        Log.i("trans","date_length : "+date.length()+"/"+date+"/"+formatType.name());
        try {
            if (formatType == Constants.DateFormatType.SLASH) {
                return SLASH_DATE_FORMAT.parse(date);
            } else if (formatType == Constants.DateFormatType.DOT) {
                return DOT_DATE_FORMAT.parse(date);
            } else if (formatType == Constants.DateFormatType.DASH) {
                return BASE_DATE_FORMAT.parse(date);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return null;

    }

    public static Date transformHms(String orderHms) {

        Log.i("trans","orderHms : "+orderHms);
        try {
            return BASE_HMS_FORMAT.parse(orderHms);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return null;
    }

    public static String transformDateStr(Date date) {
        return BASE_DATE_FORMAT.format(date);
    }

    public static String transformHmsStr(Date date) {
        return BASE_HMS_FORMAT.format(date);
    }


    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {

        try {
            if (cal == null) cal = Calendar.getInstance();

            return cal.get(Calendar.YEAR) + "-" +
                    decimalFormat.format((cal.get(Calendar.MONTH) + 1)) + "-" +
                    decimalFormat.format(cal.get(Calendar.DATE)) + " " +
                    decimalFormat.format(cal.get(Calendar.HOUR_OF_DAY)) + ":" +
                    decimalFormat.format(cal.get(Calendar.MINUTE)) + ":" +
                    decimalFormat.format(cal.get(Calendar.SECOND));
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "";
    }

    public static String convertDateFormat(String format, String oldDate) {

        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
            Date date = simpleDateFormat.parse(oldDate);
            SimpleDateFormat resultDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            return resultDateFormat.format(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return oldDate;
    }

    public static String getStartDateFormat(String format, String lastSyncDate) {
        try {

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
            //처음 1년치
            if (TextUtils.isEmpty(lastSyncDate)) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(Calendar.YEAR, -1);
                Date date = new Date();
                date.setTime(calendar.getTimeInMillis());
                return simpleDateFormat.format(date);
            } else {
                SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.getDefault());
                Date date = dt.parse(lastSyncDate);
                Calendar calendar = Calendar.getInstance();
                calendar.add(Calendar.MONTH,-1);
                date.setTime(calendar.getTimeInMillis());
                return simpleDateFormat.format(date);
            }

        } catch (ParseException e) {
            e.printStackTrace();
        }
        return getEndDateFormat(format);
    }

    /**
     * yyyyMMdd;end;today
     * @param value
     * @param lastSyncDate
     * @return
     */
    public static String getParamsDate(String value, String lastSyncDate) {

        String[] valueArr = value.split(";");

        String format = "yyyy-MM-dd";

        for (String key : valueArr) {
            if (key.contains("yy")) {
                format = key;
            }
        }
        if (value.contains("startParsingMalls"))
            return getStartDateFormat(format, lastSyncDate);
        else if (value.contains("end"))
            return getEndDateFormat(format);
        return "";
    }

    public static String getMonthStartDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH, -1);
        Date date = new Date();
        date.setTime(calendar.getTimeInMillis());
        return simpleDateFormat.format(date);
    }

    public static String getEndDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());

        return simpleDateFormat.format(new Date());
    }

    public static String getDateFormat(String format, String range, long lastScripts) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
        Log.i("getDateFormat","format : "+format+"range : "+range +"lastScripts : "+lastScripts);
        Date date = new Date();
        try {

//            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.getDefault());
//            Date date = dt.parse(lastSyncDate);
//            Calendar calendar = Calendar.getInstance();
//            calendar.add(Calendar.MONTH,-1);
//            date.setTime(calendar.getTimeInMillis())

            if (!range.equals("0M")) {
                Calendar calendar = Calendar.getInstance();
                int month = Integer.parseInt(range.replace("M",""));
                calendar.add(Calendar.MONTH, -month);
                date.setTime(calendar.getTimeInMillis());
                Log.i("1",date+" / "+ month);
            } else if(range.equals("0M") && lastScripts != 0) {
                date.setTime(lastScripts);
                Log.i("2",date+"");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return simpleDateFormat.format(date);
    }

}
