package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Element;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Gmarket extends Mall {

    public Gmarket(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty(orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10):"";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {

        if (!TextUtils.isEmpty(quantity)) {

            Pattern pattern = Pattern.compile("\\s*수량\\s*:\\s*(\\d+)개\\s*/\\s*주문번호\\s*:\\s*\\S+\\s*", Pattern.CASE_INSENSITIVE|Pattern.DOTALL);
            Matcher matcher = pattern.matcher(quantity.charAt(0)+"");
            if (matcher.matches()){
                return Integer.parseInt(matcher.group(1));
            }
        }
        return 1;
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        if (!TextUtils.isEmpty(orderNum)) {

            Pattern pattern = Pattern.compile("\\s*주문번호\\s*(\\S+)\\s*", Pattern.CASE_INSENSITIVE|Pattern.DOTALL);
            Matcher matcher = pattern.matcher(orderNum);
            if (matcher.matches()){
                return matcher.group(1);
            }
        }
        return "";
    }
}
