/*
 * Copyright 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.model.Mall_temp;

@Entity(tableName = "scraps", indices = {@Index(value = {"name"},
        unique = true)})
public final class ScrapEntity {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    @SerializedName("id")
    private final int _id;

    @NonNull
    @SerializedName("name")
    @ColumnInfo(name = "name")
    private final String mName;

    @NonNull
    @ColumnInfo(name = "display_name")
    @SerializedName("displayName")
    private final String mDisplayName;

    @Nullable
    @ColumnInfo(name = "icon_url")
    @SerializedName("iconUrl")
    private final String mIconUrl;

    @ColumnInfo(name = "version")
    private final int mVersion;

    @NonNull
    @SerializedName("loginUrl")
    @ColumnInfo(name = "login_url")
    private final String mLoginUrl;

    @NonNull
    @SerializedName("purchaseUrl")
    @ColumnInfo(name = "purchase_url")
    private final String mPurchaseUrl;

    @NonNull
    @ColumnInfo(name = "domain")
    @SerializedName("domain")
    private final String mDomain;

    @Nullable
    @ColumnInfo(name = "login_params")
    @SerializedName("loginParams")
    private final String mLoginParams;

    @ColumnInfo(name = "is_webview_login")
    @SerializedName("isWebviewLogin")
    private final int mIsWebviewLogin;

    @Nullable
    @ColumnInfo(name = "valid_cookie_keys")
    @SerializedName("validCookieKeys")
    private final String mValidCookieKeys;

    @Nullable
    @ColumnInfo(name = "purchase_page_div_css")
    @SerializedName("purchasePageDivCss")
    private final String mPurchasePageDivCss;

    @Nullable
    @ColumnInfo(name = "script_codes")
    @SerializedName("scriptCodes")
    private final String mScriptCodes;

    @Nullable
    @ColumnInfo(name = "exception_codes")
    @SerializedName("exceptionCodes")
    private final String mExceptionCodes;

    @Nullable
    @ColumnInfo(name = "reg_ex")
    @SerializedName("regEx")
    private final String mRegEx;

    @ColumnInfo(name = "purchase_method_type")
    @SerializedName("purchaseMethodType")
    private final int mPurchaseMethodType;

    @Nullable
    @ColumnInfo(name = "purchase_params")
    @SerializedName("purchaseParams")
    private final String mPurchaseParams;

    @Nullable
    @ColumnInfo(name = "purchase_page_tbl_row_css")
    @SerializedName("purchasePageTblRowCss")
    private final String mPurchasePageTblRowCss;

    @ColumnInfo(name = "detail_method_type")
    @SerializedName("detailMethodType")
    private final int mDetailMethodType;

    @Nullable
    @ColumnInfo(name = "detail_params")
    @SerializedName("detailParams")
    private final String mDetailParams;

    @Nullable
    @ColumnInfo(name = "detail_domain_url")
    @SerializedName("detailDomainUrl")
    private final String mDetailDomainUrl;

    @Nullable
    @ColumnInfo(name = "detail_page_div_css")
    @SerializedName("detailPageDivCss")
    private final String mDetailPageDivCss;


    public ScrapEntity(int _id, @NonNull String mName, @NonNull String mDisplayName, String mIconUrl, int mVersion, @NonNull String mLoginUrl, @NonNull String mPurchaseUrl, @NonNull String mDomain, String mLoginParams, int mIsWebviewLogin, String mValidCookieKeys, String mPurchasePageDivCss, String mScriptCodes, String mExceptionCodes, String mRegEx, int mPurchaseMethodType, String mPurchaseParams, String mPurchasePageTblRowCss, int mDetailMethodType, String mDetailParams, String mDetailDomainUrl, String mDetailPageDivCss) {
        this._id = _id;
        this.mName = mName;
        this.mDisplayName = mDisplayName;
        this.mIconUrl = mIconUrl;
        this.mVersion = mVersion;
        this.mLoginUrl = mLoginUrl;
        this.mPurchaseUrl = mPurchaseUrl;
        this.mDomain = mDomain;
        this.mLoginParams = mLoginParams;
        this.mIsWebviewLogin = mIsWebviewLogin;
        this.mValidCookieKeys = mValidCookieKeys;
        this.mPurchasePageDivCss = mPurchasePageDivCss;
        this.mScriptCodes = mScriptCodes;
        this.mExceptionCodes = mExceptionCodes;
        this.mRegEx = mRegEx;
        this.mPurchaseMethodType = mPurchaseMethodType;
        this.mPurchaseParams = mPurchaseParams;
        this.mPurchasePageTblRowCss = mPurchasePageTblRowCss;
        this.mDetailMethodType = mDetailMethodType;
        this.mDetailParams = mDetailParams;
        this.mDetailDomainUrl = mDetailDomainUrl;
        this.mDetailPageDivCss = mDetailPageDivCss;
    }

    public int getId() {
        return _id;
    }

    @NonNull
    public String getName() {
        return mName;
    }

    @NonNull
    public String getDisplayName() {
        return mDisplayName;
    }

    @Nullable
    public String getIconUrl() {
        return mIconUrl;
    }

    public int getVersion() {
        return mVersion;
    }

    @NonNull
    public String getLoginUrl() {
        return mLoginUrl;
    }

    @NonNull
    public String getPurchaseUrl() {
        return mPurchaseUrl;
    }

    @NonNull
    public String getDomain() {
        return mDomain;
    }

    @Nullable
    public String getLoginParams() {
        return mLoginParams;
    }

    public int getIsWebviewLogin() {
        return mIsWebviewLogin;
    }

    @Nullable
    public String getValidCookieKeys() {
        return mValidCookieKeys;
    }

    @Nullable
    public String getPurchasePageDivCss() {
        return mPurchasePageDivCss;
    }

    @Nullable
    public String getScriptCodes() {
        return mScriptCodes;
    }

    @Nullable
    public String getExceptionCodes() {
        return mExceptionCodes;
    }

    @Nullable
    public String getRegEx() {
        return mRegEx;
    }

    public int getPurchaseMethodType() {
        return mPurchaseMethodType;
    }

    @Nullable
    public String getPurchaseParams() {
        return mPurchaseParams;
    }

    @Nullable
    public String getPurchasePageTblRowCss() {
        return mPurchasePageTblRowCss;
    }

    public int getDetailMethodType() {
        return mDetailMethodType;
    }

    @Nullable
    public String getDetailParams() {
        return mDetailParams;
    }

    @Nullable
    public String getDetailDomainUrl() {
        return mDetailDomainUrl;
    }

    @Nullable
    public String getDetailPageDivCss() {
        return mDetailPageDivCss;
    }

    public Mall_temp toMall() {
        return new Mall_temp(getDisplayName(), Constants.MALL.valueOf(getName()), getIconUrl());
    }

    @Override
    public String toString() {
        return "ScrapEntity{" +
                "_id=" + _id +
                ", mName='" + mName + '\'' +
                ", mDisplayName='" + mDisplayName + '\'' +
                ", mIconUrl='" + mIconUrl + '\'' +
                ", mVersion=" + mVersion +
                ", mLoginUrl='" + mLoginUrl + '\'' +
                ", mPurchaseUrl='" + mPurchaseUrl + '\'' +
                ", mDomain='" + mDomain + '\'' +
                ", mLoginParams='" + mLoginParams + '\'' +
                ", mIsWebviewLogin=" + mIsWebviewLogin +
                ", mValidCookieKeys='" + mValidCookieKeys + '\'' +
                ", mPurchasePageDivCss='" + mPurchasePageDivCss + '\'' +
                ", mScriptCodes='" + mScriptCodes + '\'' +
                ", mExceptionCodes='" + mExceptionCodes + '\'' +
                ", mRegEx='" + mRegEx + '\'' +
                ", mPurchaseMethodType=" + mPurchaseMethodType +
                ", mPurchaseParams='" + mPurchaseParams + '\'' +
                ", mPurchasePageTblRowCss='" + mPurchasePageTblRowCss + '\'' +
                ", mDetailMethodType=" + mDetailMethodType +
                ", mDetailParams='" + mDetailParams + '\'' +
                ", mDetailDomainUrl='" + mDetailDomainUrl + '\'' +
                ", mDetailPageDivCss='" + mDetailPageDivCss + '\'' +
                '}';
    }
}
