package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Element;

public class Naver extends Mall {

    public Naver(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderDate(), 0, "href");
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
//        order.detailProdLink = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//
//        return order;
//    }

    @Override
    protected String orderDateFilter(@NonNull String orderDate) {

        return DateUtils.transformDate(orderDate.split(" ")[1].trim(), Constants.DateFormatType.DOT);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum
                .replace("/orderStatus/", "")
                .replace("https://pay.naver.com/payments/detail/", "")
                .replace("https://pay.naver.com/payments", "");
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replace("상품금액","").replace(",","").replace("원",""));
    }
}
