/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import java.util.Timer;
import java.util.TimerTask;

public class WebViewManager {
    private static final long TiMEOUT_TIMEMILLIS = 50000L;
    private WebView webView;
    private Context context;
    private Handler handler;
    private CookieManager cookieManager;
    private WebViewCallback callback;
    private Timer timer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();
    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;
    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    private int failedCnt = 0;

    @SuppressLint(value={"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context) {
        this.context = context;
        this.handler = new Handler();
        this.initWebView();
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {
        this.webView = new WebView(this.context);
        this.createCookieManager();
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
        this.webView.addJavascriptInterface((Object)new ScriptInterface(), "HtmlViewer");
        this.webView.getSettings().setDomStorageEnabled(true);
        this.webView.setLayerType(1, null);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.i((String)"onReceivedError", (String)("error : " + error));
                WebViewManager.this.stopTimer();
                if (Build.VERSION.SDK_INT >= 23) {
                    WebViewManager.this.callback.onFail(error.getErrorCode(), error.getDescription().toString());
                } else {
                    WebViewManager.this.callback.onFail(403, error.toString());
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Log.i((String)"onPageFinished", (String)("url : " + url));
                if ("about:blank".equals(url) && view.getTag() != null) {
                    view.loadUrl(view.getTag().toString());
                    return;
                }
                view.setTag((Object)url);
                WebViewManager.this.stopTimer();
                if (url.contains(WebViewManager.this.webUrl) && WebViewManager.this.scripts != null) {
                    WebViewManager.this.loadScripts(WebViewManager.this.scripts);
                    WebViewManager.this.tempScripts = WebViewManager.this.scripts;
                    WebViewManager.this.scripts = null;
                } else if (WebViewManager.this.action == 1 && WebViewManager.this.scripts == null && (url.contains(WebViewManager.this.webUrl) || url.contains("Login") || url.contains("login"))) {
                    Log.i((String)"scripts fail", (String)"!!");
                    WebViewManager.this.failedCnt++;
                    if (WebViewManager.this.failedCnt == 5) {
                        WebViewManager.this.callback.onFail(400, "\ub85c\uadf8\uc778 \uc2e4\ud328 5\ubc88");
                        return;
                    }
                    WebViewManager.this.loadScripts(WebViewManager.this.tempScripts);
                } else {
                    WebViewManager.this.failedCnt = 0;
                    WebViewManager.this.finish();
                }
            }
        });
    }

    private void sycCookie() {
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.getInstance().sync();
        } else {
            CookieManager.getInstance().flush();
        }
    }

    private void finish() {
        Log.i((String)"webview", (String)"finish");
        Toast.makeText((Context)this.context, (CharSequence)"finish", (int)0).show();
        if (this.callback != null) {
            switch (this.action) {
                case 0: {
                    this.callback.onResult(this.webUrl, this.webView);
                    break;
                }
                case 1: {
                    if (this.checkLoginState()) {
                        this.callback.onResult(this.cookieManager.getCookie(this.webUrl), this.webView);
                        break;
                    }
                    this.callback.onFail(403, "\ub85c\uadf8\uc778 \uc2e4\ud328");
                    break;
                }
                case 2: {
                    this.getHtml();
                }
            }
        }
    }

    @JavascriptInterface
    private void getHtml() {
        this.webView.loadUrl("javascript:window.HtmlViewer.showHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }

    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (this.webUrl != null) {
            this.loadWebView(this.webUrl, false);
        } else {
            callback.onFail(403, "webUrl does not exist");
            this.closeWebView();
        }
    }

    private void loadScripts(String scripts) {
        Log.i((String)"loadScripts", (String)("info : " + scripts));
        Toast.makeText((Context)this.context, (CharSequence)("loadScripts : " + scripts), (int)0).show();
        try {
            Log.i((String)"loadScripts", (String)("scripts \uc2e4\ud589 " + scripts));
            this.loadWebView(scripts, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.onFail(403, e.toString());
            this.closeWebView();
        }
    }

    private boolean checkLoginState() {
        return this.cookieManager.getCookie(this.webUrl) != null;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        this.startTimer();
        this.handler.postDelayed(() -> this.webView.loadUrl(urlOrScripts, null), 0L);
    }

    private WebViewManager createCookieManager() {
        this.cookieManager = CookieManager.getInstance();
        this.cookieManager.setAcceptCookie(true);
        this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.webView.getSettings().setSafeBrowsingEnabled(false);
        }
        return this;
    }

    private void closeWebView() {
        Log.i((String)"closeWebView", (String)"!!");
        if (this.webView != null) {
            this.handler.post(() -> {
                this.webView.stopLoading();
                this.webView.clearCache(true);
                this.webView.clearHistory();
                if (this.cookieManager != null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.cookieManager.removeSessionCookies(value -> {});
                    } else {
                        this.cookieManager.removeSessionCookie();
                    }
                    this.cookieManager.removeAllCookie();
                }
            });
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.timerTask = null;
        }
    }

    public WebView getWebView() {
        return this.webView;
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                WebViewManager.this.mTimerHandler.post(() -> {
                    WebViewManager.this.stopTimer();
                    WebViewManager.this.closeWebView();
                    WebViewManager.this.callback.onFail(403, "Timeout Fail");
                });
            }
        };
        this.timer.schedule(this.timerTask, 50000L);
    }

    public static interface WebViewCallback {
        public void onResult(String var1, WebView var2);

        public void onFail(int var1, String var2);
    }

    class ScriptInterface {
        ScriptInterface() {
        }

        @JavascriptInterface
        @SuppressLint(value={"SetJavaScriptEnabled"})
        public void showHTML(String html) {
            Log.i((String)"showHTML", (String)("html : " + html));
            if (WebViewManager.this.callback != null) {
                WebViewManager.this.callback.onResult(html, WebViewManager.this.webView);
                WebViewManager.this.closeWebView();
            }
        }
    }
}

