/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.repository;

import android.content.SharedPreferences;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.api.ScrapApiService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.ScrapDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.ScrapEntity;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.vo.Mall;
import com.tenqube.visual_scraper.vo.api.Order;
import com.tenqube.visual_scraper.vo.api.Orders;
import com.tenqube.visual_scraper.vo.api.RequestDocumentData;
import com.tenqube.visual_scraper.vo.api.RuleData;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class ScrapRepository {
    private static ScrapRepository sInstance;
    private AppExecutors appExecutors;
    private final ScraperDatabase mDatabase;
    private final UserDao userDao;
    private final ScrapDao scrapDao;
    private final OrderDao orderDao;
    private final UserWithOrdersDao userWithOrdersDao;
    private final ScrapApiService mApi;
    private SharedPreferences preferences;

    private ScrapRepository(ScraperDatabase database, ScrapApiService scrapApi, AppExecutors appExecutors, SharedPreferences preferences) {
        this.mDatabase = database;
        this.userDao = database.userDao();
        this.scrapDao = database.scrapDao();
        this.orderDao = database.orderDao();
        this.userWithOrdersDao = database.userWithOrdersDao();
        this.preferences = preferences;
        this.mApi = scrapApi;
        this.appExecutors = appExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrapRepository getInstance(ScraperDatabase database, ScrapApiService scrapApi, AppExecutors appExecutors, SharedPreferences preferences) {
        if (sInstance != null) return sInstance;
        Class<ScrapRepository> clazz = ScrapRepository.class;
        synchronized (ScrapRepository.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ScrapRepository(database, scrapApi, appExecutors, preferences);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sInstance;
        }
    }

    public void saveKey(String apiKey) {
        this.preferences.edit().putString("x-api-key", apiKey).apply();
    }

    public void saveLayer(String layer) {
        this.preferences.edit().putString("layer", layer).apply();
    }

    public void syncRule(ScrapService.Callback<Void> callback) {
        Runnable runnable = () -> {
            try {
                RuleData result;
                Response response = this.mApi.callScrapingRule(this.preferences.getInt("ruleVersion", 0)).execute();
                if (response.isSuccessful() && (result = (RuleData)response.body()) != null) {
                    this.preferences.edit().putInt("ruleVersion", result.getVersion()).apply();
                    this.scrapDao.inserts(result.getOnlineMalls());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                callback.onDataLoaded(null);
            }
        };
        this.appExecutors.networkIO().execute(runnable);
    }

    public void getUser(String userId, String pwd, Constants.MALL mall, ScrapService.Callback<UserEntity> callback) {
        Runnable runnable = () -> {
            UserEntity userEntity = null;
            try {
                userEntity = this.userDao.getUser(userId, pwd, mall.name());
                if (userEntity == null) {
                    userEntity = new UserEntity(0, mall.name(), userId, pwd, "");
                    userEntity.setId((int)this.userDao.insert(userEntity));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                UserEntity finalUserEntity = userEntity;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalUserEntity));
            }
        };
        this.appExecutors.diskIO().execute(runnable);
    }

    public void getUser(Constants.MALL mall, ScrapService.Callback<UserEntity> callback) {
        Runnable runnable = () -> {
            UserEntity userEntity = null;
            try {
                userEntity = this.userDao.getUser(mall.name());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                UserEntity finalUserEntity = userEntity;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalUserEntity));
            }
        };
        this.appExecutors.diskIO().execute(runnable);
    }

    public void deleteUser(UserEntity userEntity) {
        Runnable runnable = () -> {
            try {
                this.userDao.deleteUser(userEntity.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        this.appExecutors.diskIO().execute(runnable);
    }

    public void getMalls(ScrapService.Callback<List<Mall>> callback) {
        Runnable runnable = () -> {
            ArrayList<Mall> malls = new ArrayList<Mall>();
            try {
                List<ScrapEntity> scrapEntities = this.scrapDao.getScraps();
                for (ScrapEntity entity : scrapEntities) {
                    malls.add(entity.toMall());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(malls));
            }
        };
        this.appExecutors.diskIO().execute(runnable);
    }

    public void geScrapRule(Constants.MALL mall, ScrapService.Callback<ScrapEntity> callback) {
        Runnable runnable = () -> {
            ScrapEntity scrapEntity = null;
            try {
                scrapEntity = this.scrapDao.getScrap(mall.name());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ScrapEntity finalScrapEntity = scrapEntity;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalScrapEntity));
            }
        };
        this.appExecutors.diskIO().execute(runnable);
    }

    public void requestMallParsing(int uid, RequestDocumentData html, ScrapService.Callback<Void> callback) {
        Runnable runnable = () -> {
            try {
                Orders result;
                Response response = this.mApi.callPurchaseParser(html).execute();
                if (response.isSuccessful() && (result = (Orders)response.body()) != null) {
                    for (Order order : result.getOrders()) {
                        this.orderDao.insert(order.toEntity(uid));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(null));
            }
        };
        this.appExecutors.networkIO().execute(runnable);
    }

    public void getAllOrders(ScrapService.Callback<List<OrderEntity>> callback) {
        Runnable runnable = () -> {
            List<Object> orderEntities = new ArrayList();
            try {
                orderEntities = this.orderDao.getOrders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                List<Object> finalOrderEntities = orderEntities;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalOrderEntities));
            }
        };
        this.appExecutors.diskIO().execute(runnable);
    }
}

