/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.util.TableInfo;
import android.content.Context;
import android.os.Build;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.OrderDao_Impl;
import com.tenqube.visual_scraper.db.dao.ScrapDao;
import com.tenqube.visual_scraper.db.dao.ScrapDao_Impl;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserDao_Impl;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class ScraperDatabase_Impl
extends ScraperDatabase {
    private volatile ScrapDao _scrapDao;
    private volatile UserDao _userDao;
    private volatile OrderDao _orderDao;
    private volatile UserWithOrdersDao _userWithOrdersDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `scraps` (`_id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT NOT NULL, `display_name` TEXT NOT NULL, `icon_url` TEXT, `version` INTEGER NOT NULL, `login_url` TEXT NOT NULL, `purchase_url` TEXT NOT NULL, `domain` TEXT NOT NULL, `login_params` TEXT, `is_webview_login` INTEGER NOT NULL, `valid_cookie_keys` TEXT, `purchase_page_div_css` TEXT, `script_codes` TEXT, `exception_codes` TEXT, `reg_ex` TEXT, `purchase_method_type` INTEGER NOT NULL, `purchase_params` TEXT, `purchase_page_tbl_row_css` TEXT, `detail_method_type` INTEGER NOT NULL, `detail_params` TEXT, `detail_domain_url` TEXT, `detail_page_div_css` TEXT)");
                _db.execSQL("CREATE UNIQUE INDEX `index_scraps_name` ON `scraps` (`name`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `users` (`_id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `mall_name` TEXT NOT NULL, `uid` TEXT NOT NULL, `pwd` TEXT NOT NULL, `last_scrap_at` TEXT NOT NULL)");
                _db.execSQL("CREATE UNIQUE INDEX `index_users_mall_name_uid_pwd` ON `users` (`mall_name`, `uid`, `pwd`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `orders` (`_id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `uid` INTEGER NOT NULL, `title` TEXT NOT NULL, `order_date` TEXT NOT NULL, `order_hms` TEXT, `order_option` TEXT, `quantity` INTEGER NOT NULL, `price` INTEGER NOT NULL, `order_num` TEXT, `order_state` TEXT, `img_url` TEXT, `detail_order` TEXT, `detail_prod_link` TEXT, FOREIGN KEY(`uid`) REFERENCES `users`(`_id`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE UNIQUE INDEX `index_orders_uid_order_num` ON `orders` (`uid`, `order_num`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"1afa58bb7d642efc3e16ccc14d8dde1b\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `scraps`");
                _db.execSQL("DROP TABLE IF EXISTS `users`");
                _db.execSQL("DROP TABLE IF EXISTS `orders`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (ScraperDatabase_Impl.this.mCallbacks != null) {
                    int _size = ScraperDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ScraperDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                ScraperDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                ScraperDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (ScraperDatabase_Impl.this.mCallbacks != null) {
                    int _size = ScraperDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ScraperDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsScraps = new HashMap<String, TableInfo.Column>(22);
                _columnsScraps.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1));
                _columnsScraps.put("name", new TableInfo.Column("name", "TEXT", true, 0));
                _columnsScraps.put("display_name", new TableInfo.Column("display_name", "TEXT", true, 0));
                _columnsScraps.put("icon_url", new TableInfo.Column("icon_url", "TEXT", false, 0));
                _columnsScraps.put("version", new TableInfo.Column("version", "INTEGER", true, 0));
                _columnsScraps.put("login_url", new TableInfo.Column("login_url", "TEXT", true, 0));
                _columnsScraps.put("purchase_url", new TableInfo.Column("purchase_url", "TEXT", true, 0));
                _columnsScraps.put("domain", new TableInfo.Column("domain", "TEXT", true, 0));
                _columnsScraps.put("login_params", new TableInfo.Column("login_params", "TEXT", false, 0));
                _columnsScraps.put("is_webview_login", new TableInfo.Column("is_webview_login", "INTEGER", true, 0));
                _columnsScraps.put("valid_cookie_keys", new TableInfo.Column("valid_cookie_keys", "TEXT", false, 0));
                _columnsScraps.put("purchase_page_div_css", new TableInfo.Column("purchase_page_div_css", "TEXT", false, 0));
                _columnsScraps.put("script_codes", new TableInfo.Column("script_codes", "TEXT", false, 0));
                _columnsScraps.put("exception_codes", new TableInfo.Column("exception_codes", "TEXT", false, 0));
                _columnsScraps.put("reg_ex", new TableInfo.Column("reg_ex", "TEXT", false, 0));
                _columnsScraps.put("purchase_method_type", new TableInfo.Column("purchase_method_type", "INTEGER", true, 0));
                _columnsScraps.put("purchase_params", new TableInfo.Column("purchase_params", "TEXT", false, 0));
                _columnsScraps.put("purchase_page_tbl_row_css", new TableInfo.Column("purchase_page_tbl_row_css", "TEXT", false, 0));
                _columnsScraps.put("detail_method_type", new TableInfo.Column("detail_method_type", "INTEGER", true, 0));
                _columnsScraps.put("detail_params", new TableInfo.Column("detail_params", "TEXT", false, 0));
                _columnsScraps.put("detail_domain_url", new TableInfo.Column("detail_domain_url", "TEXT", false, 0));
                _columnsScraps.put("detail_page_div_css", new TableInfo.Column("detail_page_div_css", "TEXT", false, 0));
                HashSet _foreignKeysScraps = new HashSet(0);
                HashSet<TableInfo.Index> _indicesScraps = new HashSet<TableInfo.Index>(1);
                _indicesScraps.add(new TableInfo.Index("index_scraps_name", true, Arrays.asList("name")));
                TableInfo _infoScraps = new TableInfo("scraps", _columnsScraps, _foreignKeysScraps, _indicesScraps);
                TableInfo _existingScraps = TableInfo.read((SupportSQLiteDatabase)_db, (String)"scraps");
                if (!_infoScraps.equals((Object)_existingScraps)) {
                    throw new IllegalStateException("Migration didn't properly handle scraps(com.tenqube.visual_scraper.db.entity.ScrapEntity).\n Expected:\n" + _infoScraps + "\n" + " Found:\n" + _existingScraps);
                }
                HashMap<String, TableInfo.Column> _columnsUsers = new HashMap<String, TableInfo.Column>(5);
                _columnsUsers.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1));
                _columnsUsers.put("mall_name", new TableInfo.Column("mall_name", "TEXT", true, 0));
                _columnsUsers.put("uid", new TableInfo.Column("uid", "TEXT", true, 0));
                _columnsUsers.put("pwd", new TableInfo.Column("pwd", "TEXT", true, 0));
                _columnsUsers.put("last_scrap_at", new TableInfo.Column("last_scrap_at", "TEXT", true, 0));
                HashSet _foreignKeysUsers = new HashSet(0);
                HashSet<TableInfo.Index> _indicesUsers = new HashSet<TableInfo.Index>(1);
                _indicesUsers.add(new TableInfo.Index("index_users_mall_name_uid_pwd", true, Arrays.asList("mall_name", "uid", "pwd")));
                TableInfo _infoUsers = new TableInfo("users", _columnsUsers, _foreignKeysUsers, _indicesUsers);
                TableInfo _existingUsers = TableInfo.read((SupportSQLiteDatabase)_db, (String)"users");
                if (!_infoUsers.equals((Object)_existingUsers)) {
                    throw new IllegalStateException("Migration didn't properly handle users(com.tenqube.visual_scraper.db.entity.UserEntity).\n Expected:\n" + _infoUsers + "\n" + " Found:\n" + _existingUsers);
                }
                HashMap<String, TableInfo.Column> _columnsOrders = new HashMap<String, TableInfo.Column>(13);
                _columnsOrders.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1));
                _columnsOrders.put("uid", new TableInfo.Column("uid", "INTEGER", true, 0));
                _columnsOrders.put("title", new TableInfo.Column("title", "TEXT", true, 0));
                _columnsOrders.put("order_date", new TableInfo.Column("order_date", "TEXT", true, 0));
                _columnsOrders.put("order_hms", new TableInfo.Column("order_hms", "TEXT", false, 0));
                _columnsOrders.put("order_option", new TableInfo.Column("order_option", "TEXT", false, 0));
                _columnsOrders.put("quantity", new TableInfo.Column("quantity", "INTEGER", true, 0));
                _columnsOrders.put("price", new TableInfo.Column("price", "INTEGER", true, 0));
                _columnsOrders.put("order_num", new TableInfo.Column("order_num", "TEXT", false, 0));
                _columnsOrders.put("order_state", new TableInfo.Column("order_state", "TEXT", false, 0));
                _columnsOrders.put("img_url", new TableInfo.Column("img_url", "TEXT", false, 0));
                _columnsOrders.put("detail_order", new TableInfo.Column("detail_order", "TEXT", false, 0));
                _columnsOrders.put("detail_prod_link", new TableInfo.Column("detail_prod_link", "TEXT", false, 0));
                HashSet<TableInfo.ForeignKey> _foreignKeysOrders = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysOrders.add(new TableInfo.ForeignKey("users", "CASCADE", "NO ACTION", Arrays.asList("uid"), Arrays.asList("_id")));
                HashSet<TableInfo.Index> _indicesOrders = new HashSet<TableInfo.Index>(1);
                _indicesOrders.add(new TableInfo.Index("index_orders_uid_order_num", true, Arrays.asList("uid", "order_num")));
                TableInfo _infoOrders = new TableInfo("orders", _columnsOrders, _foreignKeysOrders, _indicesOrders);
                TableInfo _existingOrders = TableInfo.read((SupportSQLiteDatabase)_db, (String)"orders");
                if (!_infoOrders.equals((Object)_existingOrders)) {
                    throw new IllegalStateException("Migration didn't properly handle orders(com.tenqube.visual_scraper.db.entity.OrderEntity).\n Expected:\n" + _infoOrders + "\n" + " Found:\n" + _existingOrders);
                }
            }
        }, "1afa58bb7d642efc3e16ccc14d8dde1b", "ae8143c83874834b656c8bc80dfae83c");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"scraps", "users", "orders"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `scraps`");
            _db.execSQL("DELETE FROM `users`");
            _db.execSQL("DELETE FROM `orders`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrapDao scrapDao() {
        if (this._scrapDao != null) {
            return this._scrapDao;
        }
        ScraperDatabase_Impl scraperDatabase_Impl = this;
        synchronized (scraperDatabase_Impl) {
            if (this._scrapDao == null) {
                this._scrapDao = new ScrapDao_Impl(this);
            }
            return this._scrapDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDao userDao() {
        if (this._userDao != null) {
            return this._userDao;
        }
        ScraperDatabase_Impl scraperDatabase_Impl = this;
        synchronized (scraperDatabase_Impl) {
            if (this._userDao == null) {
                this._userDao = new UserDao_Impl(this);
            }
            return this._userDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderDao orderDao() {
        if (this._orderDao != null) {
            return this._orderDao;
        }
        ScraperDatabase_Impl scraperDatabase_Impl = this;
        synchronized (scraperDatabase_Impl) {
            if (this._orderDao == null) {
                this._orderDao = new OrderDao_Impl(this);
            }
            return this._orderDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserWithOrdersDao userWithOrdersDao() {
        if (this._userWithOrdersDao != null) {
            return this._userWithOrdersDao;
        }
        ScraperDatabase_Impl scraperDatabase_Impl = this;
        synchronized (scraperDatabase_Impl) {
            if (this._userWithOrdersDao == null) {
                this._userWithOrdersDao = new UserWithOrdersDao_Impl(this);
            }
            return this._userWithOrdersDao;
        }
    }
}

