/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static final DecimalFormat decimalFormat = new DecimalFormat("00");
    public static final DecimalFormat firstdF = new DecimalFormat("0.#");

    public static String getTodayDate() {
        Calendar cal = Calendar.getInstance();
        return DateUtils.getStringDateAsYYYYMMddHHmmss(cal);
    }

    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {
        try {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            return cal.get(1) + "-" + decimalFormat.format(cal.get(2) + 1) + "-" + decimalFormat.format(cal.get(5)) + " " + decimalFormat.format(cal.get(11)) + ":" + decimalFormat.format(cal.get(12)) + ":" + decimalFormat.format(cal.get(13));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String convertDateFormat(String format, String oldDate) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
            Date date = simpleDateFormat.parse(oldDate);
            SimpleDateFormat resultDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            return resultDateFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return oldDate;
        }
    }

    public static String getStartDateFormat(String format, String lastSyncDate) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
            if (lastSyncDate == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(1, -1);
                Date date = new Date();
                date.setTime(calendar.getTimeInMillis());
                return simpleDateFormat.format(date);
            }
            SimpleDateFormat dt = new SimpleDateFormat("yyyyy-MM-dd hh:mm:ss", Locale.getDefault());
            Date date = dt.parse(lastSyncDate);
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            date.setTime(calendar.getTimeInMillis());
            return simpleDateFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return DateUtils.getEndDateFormat(format);
        }
    }

    public static String getParamsDate(String value, String lastSyncDate) {
        String[] valueArr = value.split(";");
        String format = "yyyy-MM-dd";
        for (String key : valueArr) {
            if (!key.contains("yy")) continue;
            format = key;
        }
        if (value.contains("start")) {
            return DateUtils.getStartDateFormat(format, lastSyncDate);
        }
        if (value.contains("end")) {
            return DateUtils.getEndDateFormat(format);
        }
        return "";
    }

    public static String getMonthStartDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = new Date();
        date.setTime(calendar.getTimeInMillis());
        return simpleDateFormat.format(date);
    }

    public static String getEndDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }
}

