/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.request_interface.visualserver;

import android.support.annotation.NonNull;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class VisualCallAdapter {
    public static final String TAG = "VisualCallAdapter";

    static class MyCallAdapter<T>
    implements MyCall<T> {
        private final Call<T> call;
        private final Executor callbackExecutor;

        MyCallAdapter(Call<T> call, Executor callbackExecutor) {
            this.call = call;
            this.callbackExecutor = callbackExecutor;
        }

        @Override
        public void cancel() {
            this.call.cancel();
        }

        @Override
        public void enqueue(final MyCallback<T> callback) {
            this.call.enqueue(new Callback<T>(){

                public void onResponse(@NonNull Call<T> call, @NonNull Response<T> response) {
                    int code = response.code();
                    if (code >= 200 && code < 300) {
                        callback.success(response);
                    } else if (code == 403) {
                        callback.deny();
                    } else {
                        callback.fail(response);
                    }
                }

                public void onFailure(@NonNull Call<T> call, @NonNull Throwable t) {
                    LogUtil.LOGI(VisualCallAdapter.TAG, "onFailure Msg:" + t.getMessage());
                    callback.fail(null);
                }
            });
        }

        @Override
        public MyCall<T> clone() {
            return new MyCallAdapter<T>(this.call.clone(), this.callbackExecutor);
        }
    }

    public static class VisualCallAdapterFactory
    extends CallAdapter.Factory {
        public CallAdapter<?, ?> get(@NonNull Type returnType, @NonNull Annotation[] annotations, @NonNull Retrofit retrofit) {
            if (VisualCallAdapterFactory.getRawType((Type)returnType) != MyCall.class) {
                return null;
            }
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalStateException("MyCall must have generic type (e.g., MyCall<ResponseBody>)");
            }
            Type responseType = VisualCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
            Executor callbackExecutor = retrofit.callbackExecutor();
            return new ErrorHandlingAdapter(responseType, callbackExecutor);
        }

        private static final class ErrorHandlingAdapter<R>
        implements CallAdapter<R, MyCall<R>> {
            private final Type responseType;
            private final Executor callbackExecutor;

            ErrorHandlingAdapter(Type responseType, Executor callbackExecutor) {
                this.responseType = responseType;
                this.callbackExecutor = callbackExecutor;
            }

            public Type responseType() {
                return this.responseType;
            }

            public MyCall<R> adapt(@NonNull Call<R> call) {
                return new MyCallAdapter<R>(call, this.callbackExecutor);
            }
        }
    }

    static interface MyCall<T> {
        public void cancel();

        public void enqueue(MyCallback<T> var1);

        public MyCall<T> clone();
    }

    static interface MyCallback<T> {
        public void success(Response<T> var1);

        public void deny();

        public void fail(Response<?> var1);
    }
}

