/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.request_interface.login;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tenqube.visual_scraper.R;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.request_interface.login.LoginRequest;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.util.Timer;
import java.util.TimerTask;

public class WebViewLogin
implements LoginRequest {
    private LoginRequest.OnResponse mResponse;
    private static ParsingRuleData mParsingRuleData;
    private ViewGroup viewGroup;
    private Handler handler;
    private WebView webView;
    private View webViewLayout;
    private boolean usedLoginScript;
    private boolean isLoginSuccess;
    private static final long TiMEOUT_TIMEMILLIS = 10000L;
    private static WebViewLogin mInstance;
    private Timer timer;
    private TimerTask timerTask;
    private Activity mActivity;
    private static final String TAG;

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    private WebViewLogin(Activity activity, ParsingRuleData parsingRuleData) {
        mParsingRuleData = parsingRuleData;
        this.mActivity = activity;
        this.handler = new Handler();
        this.init(activity);
    }

    public static WebViewLogin getInstance(Activity activity, ParsingRuleData parsingRuleData) {
        if (mInstance == null) {
            mInstance = new WebViewLogin(activity, parsingRuleData);
        } else {
            mInstance.init(activity);
            mParsingRuleData = parsingRuleData;
        }
        return mInstance;
    }

    private void init(final Activity activity) {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                WebViewLogin.this.closeWebView();
                WebViewLogin.this.usedLoginScript = false;
                WebViewLogin.this.mResponse.onLoginFail(403, "Timeout Fail");
            }
        };
        this.viewGroup = (ViewGroup)activity.getWindow().getDecorView().getRootView();
        LayoutInflater inflater = (LayoutInflater)activity.getSystemService("layout_inflater");
        if (inflater != null) {
            this.webViewLayout = inflater.inflate(R.layout.web_view_layout, null);
            this.viewGroup.addView(this.webViewLayout);
            this.webView = (WebView)this.webViewLayout.findViewById(R.id.visual_web_view);
            CookieManager.getInstance().setAcceptCookie(true);
            final CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)activity);
            }
            cookieManager.setAcceptCookie(true);
            if (Build.VERSION.SDK_INT >= 26) {
                this.webView.getSettings().setSafeBrowsingEnabled(false);
            }
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
            this.webView.setWebViewClient(new WebViewClient(){

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    if (Build.VERSION.SDK_INT >= 19) {
                        LogUtil.LOGI(TAG, "\uc608\uc678\ucf54\ub4dc\uac1c\uc218 : " + mParsingRuleData.exceptScriptCode.size() + ", \ub85c\uadf8\uc778 ddd\uc2a4\ud06c\ub9bd\ud2b8 \uc37b\ub098 " + WebViewLogin.this.usedLoginScript + " , \uc131\uacf5\ud588\ub098 " + WebViewLogin.this.isLoginSuccess + " , \uae30\uae30\ub4f1\ub85d \ud588\ub098 " + PreferenceManager.getDefaultSharedPreferences((Context)activity).getBoolean("usedExceptScriptCode", true));
                        if (WebViewLogin.this.usedLoginScript && cookieManager.getCookie(url) != null && mParsingRuleData.exceptScriptCode.size() == 0) {
                            WebViewLogin.this.isLoginSuccess = WebViewLogin.this.invalidloginCheck(cookieManager.getCookie(url));
                            if (WebViewLogin.this.isLoginSuccess) {
                                WebViewLogin.this.invalidUserLoginSuccess(cookieManager.getCookie(url));
                            } else {
                                WebViewLogin.this.invalidUserLoginFail();
                            }
                        }
                        if (!WebViewLogin.this.usedLoginScript) {
                            WebViewLogin.this.setTimeout();
                            view.loadUrl(mParsingRuleData.webViewScriptCode, null);
                            WebViewLogin.this.usedLoginScript = true;
                        } else if (mParsingRuleData.exceptScriptCode.size() > 0) {
                            view.loadUrl(mParsingRuleData.exceptScriptCode.get(0), null);
                            mParsingRuleData.exceptScriptCode.remove(0);
                        } else if (mParsingRuleData.exceptScriptCode.size() >= 0) {
                            WebViewLogin.this.usedLoginScript = false;
                        }
                    }
                }

                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    return super.shouldOverrideUrlLoading(view, request);
                }
            });
        }
    }

    @Override
    public void doLogin() {
        try {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    WebViewLogin.this.webView.loadUrl(mParsingRuleData.loginUrl);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOnResponseCallbackListener(LoginRequest.OnResponse responseCallbackListener) {
        this.mResponse = responseCallbackListener;
    }

    void closeWebView() {
        if (this.webView != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    WebViewLogin.this.webView.stopLoading();
                    WebViewLogin.this.webView.clearCache(true);
                    WebViewLogin.this.webView.clearHistory();
                    WebViewLogin.this.viewGroup.removeView(WebViewLogin.this.webViewLayout);
                    WebViewLogin.this.webViewLayout = null;
                    CookieManager cookieManager = CookieManager.getInstance();
                    if (Build.VERSION.SDK_INT >= 21) {
                        cookieManager.removeSessionCookies((ValueCallback)new ValueCallback<Boolean>(){

                            public void onReceiveValue(Boolean value) {
                            }
                        });
                    } else {
                        cookieManager.removeSessionCookie();
                    }
                    cookieManager.removeAllCookie();
                }
            });
        }
    }

    private void invalidUserLoginFail() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebViewLogin.this.mResponse.onLoginFail(403, "Invalid User Info");
            }
        }).start();
        this.cancelTimeout();
        this.closeWebView();
    }

    private void invalidUserLoginSuccess(final String cookie) {
        this.cancelTimeout();
        this.closeWebView();
        PreferenceManager.getDefaultSharedPreferences((Context)this.mActivity).edit().putBoolean("usedExceptScriptCode", false).apply();
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebViewLogin.this.mResponse.onLoginSuccess(cookie);
            }
        }).start();
    }

    private boolean invalidloginCheck(String cookie) {
        LogUtil.LOGI(TAG, cookie);
        for (String invalidKey : WebViewLogin.mParsingRuleData.validCookieKey) {
            if (cookie.contains(invalidKey)) continue;
            return false;
        }
        return true;
    }

    private void setTimeout() {
        if (this.timer != null && this.timerTask != null) {
            this.timer.schedule(this.timerTask, 10000L);
        }
    }

    private void cancelTimeout() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    static {
        mInstance = null;
        TAG = LogUtil.makeLogTag(WebViewLogin.class);
    }
}

