package com.tenqube.visual_scraper.request_interface.visualserver;

import com.tenqube.visual_scraper.data.dto_data.RuleData;
import com.tenqube.visual_scraper.data.parsed_data.Orders;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.RequestOrders;

/**
 * Created by tenqube on 2018. 6. 14..
 */

public interface VisualApi {

    /**
     *
     * 비주얼 파싱 서버로 주문 페이지를 요청한다.
     * @param callback visual api 통신 응답 콜백
     * @param requestDocumentData request 데이터
     */
    public void callPurchaseParsing(final VisualApiImpl.OnNetworkResultListener<Orders> callback, RequestDocumentData requestDocumentData);



    /**
     *
     * 비주얼 파싱 서버로 상세페이지를 요청한다.
     * @param callback visual api 통신 응답 콜백
     * @param requestDocumentData request 데이터
     */
    public void callDetailPurchaseParsing(final VisualApiImpl.OnNetworkResultListener<Orders> callback, RequestDocumentData requestDocumentData);

    /**
     * 스크래핑 룰 동기화 요청
     * @param callback visual api 통신 응답 콜백
     * @param version version으로 동기화를 한다
     */

    public void callScrapingRule(final VisualApiImpl.OnNetworkResultListener<RuleData> callback, final int version);

    public void callOrders(VisualApiImpl.OnNetworkResultListener<Void> onNetworkResultListener, RequestOrders requestOrders);
}
